/**
 * Copyright (c) 2019 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at:
 *
 *     https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
package org.eclipse.jkube.gradle.plugin.task;

import org.eclipse.jkube.gradle.plugin.OpenShiftExtension;

import javax.inject.Inject;
import java.io.File;
import java.util.List;

public class OpenShiftUndeployTask extends KubernetesUndeployTask implements OpenShiftJKubeTask {
  @Inject
  public OpenShiftUndeployTask(Class<? extends OpenShiftExtension> extensionClass) {
    super(extensionClass);
    setDescription(
      "Undeploys (deletes) the OpenShift resources generated by the current project.");
  }

  @Override
  protected List<File> findManifestsToUndeploy() {
    final List<File> ret = super.findManifestsToUndeploy();
    ret.add(getOpenShiftExtension().getImageStreamManifestOrDefault());
    return ret;
  }
}
