/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.jgroups.springboot.cluster.springboot;

import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.jgroups.cluster.JGroupsLockClusterService;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.cluster.ClusteredRouteControllerAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import java.util.Optional;

@Configuration
@AutoConfigureBefore({ ClusteredRouteControllerAutoConfiguration.class, CamelAutoConfiguration.class })
@ConditionalOnProperty(prefix = "camel.cluster.jgroups", name = "enabled")
@EnableConfigurationProperties(JGroupsLockClusterServiceConfiguration.class)
public class JGroupsLockClusterServiceAutoConfiguration {

    @Autowired
    private JGroupsLockClusterServiceConfiguration configuration;

    @Bean(name = "jgroups-lock-cluster-service")
    @Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
    public CamelClusterService zookeeperClusterService() throws Exception {
        JGroupsLockClusterService service = new JGroupsLockClusterService();

        Optional.ofNullable(configuration.getId())
                .ifPresent(service::setId);
        Optional.ofNullable(configuration.getJgroupsClusterName())
                .ifPresent(service::setJgroupsClusterName);
        Optional.ofNullable(configuration.getJgroupsConfig())
                .ifPresent(service::setJgroupsConfig);

        return service;
    }
}
