/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.jte.springboot;

import gg.jte.ContentType;
import org.apache.camel.component.jte.JteComponent;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Transform messages using a Java based template engine (JTE).
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.jte")
public class JteComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the jte component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * Sets whether the context map should allow access to all details. By
     * default only the message body and headers can be accessed. This option
     * can be enabled for full access to the current Exchange and CamelContext.
     * Doing so impose a potential security risk as this opens access to the
     * full power of CamelContext API.
     */
    private Boolean allowContextMapAll = false;
    /**
     * Whether to allow to use resource template from header or not (default
     * false). Enabling this allows to specify dynamic templates via message
     * header. However this can be seen as a potential security vulnerability if
     * the header is coming from a malicious user, so use this with care.
     */
    private Boolean allowTemplateFromHeader = false;
    /**
     * Content type the JTE engine should use.
     */
    private ContentType contentType = ContentType.Plain;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * To speed up startup and rendering on your production server, it is
     * possible to precompile all templates during the build. This way, the
     * template engine can load each template's .class file directly without
     * first compiling it.
     */
    private Boolean preCompile = false;
    /**
     * Work directory where JTE will store compiled templates.
     */
    private String workDir = "jte-classes";
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;

    public Boolean getAllowContextMapAll() {
        return allowContextMapAll;
    }

    public void setAllowContextMapAll(Boolean allowContextMapAll) {
        this.allowContextMapAll = allowContextMapAll;
    }

    public Boolean getAllowTemplateFromHeader() {
        return allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(Boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public ContentType getContentType() {
        return contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Boolean getPreCompile() {
        return preCompile;
    }

    public void setPreCompile(Boolean preCompile) {
        this.preCompile = preCompile;
    }

    public String getWorkDir() {
        return workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }
}