/**
 * @license
 * Copyright 2020 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import React from "react";
import "./header.css";
import {
    Divider,
    Flex,
    FlexItem,
    Masthead,
    MastheadBrand,
    MastheadContent,
    Title,
    Toolbar,
    ToolbarContent,
    ToolbarItem
} from "@patternfly/react-core";
import brandImg from "./red-hat-logo-reverse-transparent-100px.png";
import {PureComponent, PureComponentProps, PureComponentState} from "../baseComponent";
import {IfAuth} from "../common/ifAuth";
import {AvatarDropdown} from "./avatarDropdown";


// tslint:disable-next-line:no-empty-interface
export interface AppHeaderProps extends PureComponentProps {
}

// tslint:disable-next-line:no-empty-interface
export interface AppHeaderState extends PureComponentState {
}


export class AppHeader extends PureComponent<AppHeaderProps, AppHeaderState> {

    constructor(props: Readonly<AppHeaderProps>) {
        super(props);
    }

    public render(): React.ReactElement {
        return (
            <Masthead>
                <MastheadBrand onClick={this.navigateTo(this.linkTo("/artifacts"))} aria-label="go to home page">
                    <Flex className="pf-m-center pf-m-vertical">
                        <FlexItem>
                            <img alt="Red Hat" className="brand-img" id="masthead-logo" src={brandImg}/>
                        </FlexItem>
                        <Divider inset={{default: 'insetMd'}} orientation={{default: 'vertical'}}/>
                        <FlexItem>
                            <Title headingLevel="h3">Red Hat build of Apicurio Registry</Title>
                        </FlexItem>
                    </Flex>
                </MastheadBrand>
                <MastheadContent>
                    <Toolbar>
                        <ToolbarContent>
                            <ToolbarItem alignment={{default: "alignRight"}} id="avatar">
                                <IfAuth enabled={true}>
                                    <AvatarDropdown/>
                                </IfAuth>
                            </ToolbarItem>
                        </ToolbarContent>
                    </Toolbar>
                </MastheadContent>
            </Masthead>
        );
    }

    protected initializeState(): AppHeaderState {
        return {};
    }
}
