/*
 * Copyright 2021 Red Hat
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.apicurio.registry;

import io.apicurio.rest.client.auth.AccessTokenResponse;
import io.quarkus.runtime.annotations.RegisterForReflection;

/**
 * @author Fabian Martinez
 */
@RegisterForReflection(targets = {
  AccessTokenResponse.class,
  // Needed for the JAXRSClient
  org.apache.commons.logging.LogFactory.class,
  org.apache.commons.logging.impl.LogFactoryImpl.class,
  org.apache.commons.logging.impl.SimpleLog.class,
  // The following list is generated running `jbang cli/tools/extractRegisterForReflection.java`
  io.apicurio.datamodels.models.Components.class,
  io.apicurio.datamodels.models.Contact.class,
  io.apicurio.datamodels.models.Document.class,
  io.apicurio.datamodels.models.ExternalDocumentation.class,
  io.apicurio.datamodels.models.Info.class,
  io.apicurio.datamodels.models.License.class,
  io.apicurio.datamodels.models.NodeImpl.class,
  io.apicurio.datamodels.models.OAuthFlow.class,
  io.apicurio.datamodels.models.OAuthFlows.class,
  io.apicurio.datamodels.models.Operation.class,
  io.apicurio.datamodels.models.Parameter.class,
  io.apicurio.datamodels.models.RootNode.class,
  io.apicurio.datamodels.models.RootNodeImpl.class,
  io.apicurio.datamodels.models.Schema.class,
  io.apicurio.datamodels.models.SecurityRequirement.class,
  io.apicurio.datamodels.models.SecurityScheme.class,
  io.apicurio.datamodels.models.Server.class,
  io.apicurio.datamodels.models.ServerVariable.class,
  io.apicurio.datamodels.models.Tag.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiBinding.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiChannelBindings.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiChannelItem.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiChannels.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiComponents.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiContact.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiCorrelationID.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiDocument.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiExternalDocumentation.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiInfo.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiLicense.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiMessage.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiMessageBindings.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiMessageExample.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiMessageTrait.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiOAuthFlow.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiOAuthFlows.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiOneOfMessages.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiOperation.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiOperationBindings.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiOperationTrait.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiParameter.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiParameters.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiSchema.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiSecurityRequirement.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiSecurityScheme.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiServer.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiServerBindings.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiServerVariable.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiServers.class,
  io.apicurio.datamodels.models.asyncapi.AsyncApiTag.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Binding.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20BindingImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ChannelBindings.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ChannelBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ChannelItem.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ChannelItemImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Channels.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ChannelsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Components.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ComponentsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Contact.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ContactImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20CorrelationID.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20CorrelationIDImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Document.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20DocumentImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ExternalDocumentation.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ExternalDocumentationImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Info.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20InfoImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20License.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20LicenseImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Message.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20MessageBindings.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20MessageBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20MessageImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20MessageTrait.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20MessageTraitImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OAuthFlow.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OAuthFlowImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OAuthFlows.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OAuthFlowsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OneOfMessages.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OneOfMessagesImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Operation.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OperationBindings.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OperationBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OperationImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OperationTrait.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20OperationTraitImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Parameter.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ParameterImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Parameters.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ParametersImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Schema.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20SchemaImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20SecurityRequirement.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20SecurityRequirementImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20SecurityScheme.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20SecuritySchemeImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Server.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ServerBindings.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ServerBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ServerImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ServerVariable.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ServerVariableImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Servers.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20ServersImpl.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20Tag.class,
  io.apicurio.datamodels.models.asyncapi.v20.AsyncApi20TagImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Binding.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21BindingImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ChannelBindings.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ChannelBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ChannelItem.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ChannelItemImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Channels.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ChannelsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Components.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ComponentsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Contact.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ContactImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21CorrelationID.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21CorrelationIDImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Document.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21DocumentImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ExternalDocumentation.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ExternalDocumentationImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Info.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21InfoImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21License.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21LicenseImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Message.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21MessageBindings.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21MessageBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21MessageImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21MessageTrait.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21MessageTraitImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21OAuthFlow.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21OAuthFlowImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21OAuthFlows.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21OAuthFlowsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21OneOfMessages.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21OneOfMessagesImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Operation.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21OperationBindings.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21OperationBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21OperationImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21OperationTrait.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21OperationTraitImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Parameter.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ParameterImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Parameters.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ParametersImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Schema.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21SchemaImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21SecurityRequirement.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21SecurityRequirementImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21SecurityScheme.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21SecuritySchemeImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Server.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ServerBindings.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ServerBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ServerImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ServerVariable.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ServerVariableImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Servers.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21ServersImpl.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21Tag.class,
  io.apicurio.datamodels.models.asyncapi.v21.AsyncApi21TagImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Binding.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22BindingImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ChannelBindings.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ChannelBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ChannelItem.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ChannelItemImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Channels.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ChannelsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Components.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ComponentsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Contact.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ContactImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22CorrelationID.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22CorrelationIDImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Document.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22DocumentImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ExternalDocumentation.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ExternalDocumentationImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Info.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22InfoImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22License.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22LicenseImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Message.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22MessageBindings.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22MessageBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22MessageExample.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22MessageExampleImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22MessageImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22MessageTrait.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22MessageTraitImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22OAuthFlow.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22OAuthFlowImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22OAuthFlows.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22OAuthFlowsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22OneOfMessages.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22OneOfMessagesImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Operation.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22OperationBindings.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22OperationBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22OperationImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22OperationTrait.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22OperationTraitImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Parameter.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ParameterImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Parameters.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ParametersImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Schema.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22SchemaImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22SecurityRequirement.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22SecurityRequirementImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22SecurityScheme.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22SecuritySchemeImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Server.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ServerBindings.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ServerBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ServerImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ServerVariable.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ServerVariableImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Servers.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22ServersImpl.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22Tag.class,
  io.apicurio.datamodels.models.asyncapi.v22.AsyncApi22TagImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Binding.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23BindingImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ChannelBindings.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ChannelBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ChannelItem.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ChannelItemImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Channels.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ChannelsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Components.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ComponentsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Contact.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ContactImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23CorrelationID.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23CorrelationIDImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Document.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23DocumentImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ExternalDocumentation.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ExternalDocumentationImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Info.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23InfoImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23License.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23LicenseImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Message.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23MessageBindings.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23MessageBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23MessageExample.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23MessageExampleImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23MessageImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23MessageTrait.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23MessageTraitImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23OAuthFlow.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23OAuthFlowImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23OAuthFlows.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23OAuthFlowsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23OneOfMessages.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23OneOfMessagesImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Operation.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23OperationBindings.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23OperationBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23OperationImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23OperationTrait.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23OperationTraitImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Parameter.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ParameterImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Parameters.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ParametersImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Schema.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23SchemaImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23SecurityRequirement.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23SecurityRequirementImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23SecurityScheme.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23SecuritySchemeImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Server.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ServerBindings.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ServerBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ServerImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ServerVariable.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ServerVariableImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Servers.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23ServersImpl.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23Tag.class,
  io.apicurio.datamodels.models.asyncapi.v23.AsyncApi23TagImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Binding.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24BindingImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ChannelBindings.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ChannelBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ChannelItem.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ChannelItemImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Channels.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ChannelsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Components.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ComponentsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Contact.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ContactImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24CorrelationID.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24CorrelationIDImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Document.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24DocumentImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ExternalDocumentation.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ExternalDocumentationImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Info.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24InfoImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24License.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24LicenseImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Message.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24MessageBindings.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24MessageBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24MessageExample.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24MessageExampleImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24MessageImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24MessageTrait.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24MessageTraitImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24OAuthFlow.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24OAuthFlowImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24OAuthFlows.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24OAuthFlowsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24OneOfMessages.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24OneOfMessagesImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Operation.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24OperationBindings.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24OperationBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24OperationImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24OperationTrait.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24OperationTraitImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Parameter.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ParameterImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Parameters.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ParametersImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Schema.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24SchemaImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24SecurityRequirement.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24SecurityRequirementImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24SecurityScheme.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24SecuritySchemeImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Server.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ServerBindings.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ServerBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ServerImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ServerVariable.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ServerVariableImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Servers.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24ServersImpl.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24Tag.class,
  io.apicurio.datamodels.models.asyncapi.v24.AsyncApi24TagImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Binding.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25BindingImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ChannelBindings.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ChannelBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ChannelItem.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ChannelItemImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Channels.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ChannelsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Components.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ComponentsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Contact.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ContactImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25CorrelationID.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25CorrelationIDImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Document.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ExternalDocumentation.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ExternalDocumentationImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Info.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25InfoImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25License.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25LicenseImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Message.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25MessageBindings.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25MessageBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25MessageExample.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25MessageExampleImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25MessageImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25MessageTrait.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25MessageTraitImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25OAuthFlow.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25OAuthFlowImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25OAuthFlows.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25OAuthFlowsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25OneOfMessages.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25OneOfMessagesImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Operation.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25OperationBindings.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25OperationBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25OperationImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25OperationTrait.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25OperationTraitImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Parameter.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ParameterImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Parameters.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ParametersImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Schema.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SecurityRequirement.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SecurityRequirementImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SecurityScheme.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SecuritySchemeImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Server.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ServerBindings.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ServerBindingsImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ServerImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ServerVariable.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ServerVariableImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Servers.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ServersImpl.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Tag.class,
  io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25TagImpl.class,
  io.apicurio.datamodels.models.openapi.OpenApiCallback.class,
  io.apicurio.datamodels.models.openapi.OpenApiComponents.class,
  io.apicurio.datamodels.models.openapi.OpenApiContact.class,
  io.apicurio.datamodels.models.openapi.OpenApiDiscriminator.class,
  io.apicurio.datamodels.models.openapi.OpenApiDocument.class,
  io.apicurio.datamodels.models.openapi.OpenApiEncoding.class,
  io.apicurio.datamodels.models.openapi.OpenApiExample.class,
  io.apicurio.datamodels.models.openapi.OpenApiExternalDocumentation.class,
  io.apicurio.datamodels.models.openapi.OpenApiHeader.class,
  io.apicurio.datamodels.models.openapi.OpenApiInfo.class,
  io.apicurio.datamodels.models.openapi.OpenApiLicense.class,
  io.apicurio.datamodels.models.openapi.OpenApiLink.class,
  io.apicurio.datamodels.models.openapi.OpenApiMediaType.class,
  io.apicurio.datamodels.models.openapi.OpenApiOAuthFlow.class,
  io.apicurio.datamodels.models.openapi.OpenApiOAuthFlows.class,
  io.apicurio.datamodels.models.openapi.OpenApiOperation.class,
  io.apicurio.datamodels.models.openapi.OpenApiParameter.class,
  io.apicurio.datamodels.models.openapi.OpenApiPathItem.class,
  io.apicurio.datamodels.models.openapi.OpenApiPaths.class,
  io.apicurio.datamodels.models.openapi.OpenApiRequestBody.class,
  io.apicurio.datamodels.models.openapi.OpenApiResponse.class,
  io.apicurio.datamodels.models.openapi.OpenApiResponses.class,
  io.apicurio.datamodels.models.openapi.OpenApiSchema.class,
  io.apicurio.datamodels.models.openapi.OpenApiSecurityRequirement.class,
  io.apicurio.datamodels.models.openapi.OpenApiSecurityScheme.class,
  io.apicurio.datamodels.models.openapi.OpenApiServer.class,
  io.apicurio.datamodels.models.openapi.OpenApiServerVariable.class,
  io.apicurio.datamodels.models.openapi.OpenApiTag.class,
  io.apicurio.datamodels.models.openapi.OpenApiXML.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Contact.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ContactImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Definitions.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20DefinitionsImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Document.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20DocumentImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Example.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ExampleImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ExternalDocumentation.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ExternalDocumentationImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Header.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20HeaderImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Headers.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20HeadersImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Info.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20InfoImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Items.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ItemsImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20License.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20LicenseImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Operation.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20OperationImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Parameter.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ParameterDefinitions.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ParameterDefinitionsImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ParameterImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20PathItem.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20PathItemImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Paths.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20PathsImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Response.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ResponseDefinitions.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ResponseDefinitionsImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ResponseImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Responses.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ResponsesImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Schema.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20SchemaImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Scopes.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20ScopesImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20SecurityDefinitions.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20SecurityDefinitionsImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20SecurityRequirement.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20SecurityRequirementImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20SecurityScheme.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20SecuritySchemeImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20Tag.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20TagImpl.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20XML.class,
  io.apicurio.datamodels.models.openapi.v20.OpenApi20XMLImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Callback.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30CallbackImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Components.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30ComponentsImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Contact.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30ContactImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Discriminator.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30DiscriminatorImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Document.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30DocumentImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Encoding.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30EncodingImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Example.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30ExampleImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30ExternalDocumentation.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30ExternalDocumentationImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Header.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30HeaderImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Info.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30InfoImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30License.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30LicenseImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Link.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30LinkImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30MediaType.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30MediaTypeImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30OAuthFlow.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30OAuthFlowImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30OAuthFlows.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30OAuthFlowsImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Operation.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30OperationImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Parameter.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30ParameterImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30PathItem.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30PathItemImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Paths.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30PathsImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30RequestBody.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30RequestBodyImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Response.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30ResponseImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Responses.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30ResponsesImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Schema.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30SchemaImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30SecurityRequirement.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30SecurityRequirementImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30SecurityScheme.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30SecuritySchemeImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Server.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30ServerImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30ServerVariable.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30ServerVariableImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30Tag.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30TagImpl.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30XML.class,
  io.apicurio.datamodels.models.openapi.v30.OpenApi30XMLImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Callback.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31CallbackImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Components.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31ComponentsImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Contact.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31ContactImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Discriminator.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31DiscriminatorImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Document.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31DocumentImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Encoding.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31EncodingImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Example.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31ExampleImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31ExternalDocumentation.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31ExternalDocumentationImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Header.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31HeaderImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Info.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31InfoImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31License.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31LicenseImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Link.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31LinkImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31MediaType.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31MediaTypeImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31OAuthFlow.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31OAuthFlowImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31OAuthFlows.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31OAuthFlowsImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Operation.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31OperationImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Parameter.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31ParameterImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31PathItem.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31PathItemImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Paths.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31PathsImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31RequestBody.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31RequestBodyImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Response.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31ResponseImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Responses.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31ResponsesImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Schema.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31SchemaImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31SecurityRequirement.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31SecurityRequirementImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31SecurityScheme.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31SecuritySchemeImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Server.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31ServerImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31ServerVariable.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31ServerVariableImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31Tag.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31TagImpl.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31XML.class,
  io.apicurio.datamodels.models.openapi.v31.OpenApi31XMLImpl.class,
  io.apicurio.datamodels.validation.rules.invalid.format.InvalidApiDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.InvalidContactEmailRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.InvalidContactUrlRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.InvalidExternalDocsDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.InvalidLicenseUrlRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.InvalidServerDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.InvalidServerUrlRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.InvalidTagDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.InvalidTermsOfServiceUrlRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidApiBasePathRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidApiHostRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidExampleDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidExternalDocsUrlRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidHeaderDefaultValueRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidHeaderDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidLinkDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidOAuthAuthorizationUrlRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidOAuthRefreshUrlRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidOAuthTokenUrlRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidOpenIDConnectUrlRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidOperationConsumesRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidOperationDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidOperationProducesRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidParameterDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidPathItemDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidRequestBodyDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidResponseDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidSchemaItemsDefaultValueRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidSecuritySchemeAuthUrlRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidSecuritySchemeDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidSecuritySchemeTokenUrlRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidServerVariableDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.format.OasInvalidXmlNamespaceUrlRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasDuplicatePathSegmentRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasEmptyPathSegmentRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasIdenticalPathTemplateRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidCallbackDefinitionNameRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidExampleDefinitionNameRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidHeaderDefinitionNameRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidHttpResponseCodeRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidLinkDefinitionNameRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidParameterDefNameRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidPathSegmentRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidPropertyNameRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidRequestBodyDefinitionNameRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidResponseDefNameRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidSchemaDefNameRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidScopeNameRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasInvalidSecuritySchemeNameRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasUnmatchedEncodingPropertyRule.class,
  io.apicurio.datamodels.validation.rules.invalid.name.OasUnmatchedExampleTypeRule.class,
  io.apicurio.datamodels.validation.rules.invalid.reference.OasInvalidCallbackReferenceRule.class,
  io.apicurio.datamodels.validation.rules.invalid.reference.OasInvalidExampleReferenceRule.class,
  io.apicurio.datamodels.validation.rules.invalid.reference.OasInvalidHeaderReferenceRule.class,
  io.apicurio.datamodels.validation.rules.invalid.reference.OasInvalidLinkOperationReferenceRule.class,
  io.apicurio.datamodels.validation.rules.invalid.reference.OasInvalidLinkReferenceRule.class,
  io.apicurio.datamodels.validation.rules.invalid.reference.OasInvalidParameterReferenceRule.class,
  io.apicurio.datamodels.validation.rules.invalid.reference.OasInvalidPathItemReferenceRule.class,
  io.apicurio.datamodels.validation.rules.invalid.reference.OasInvalidRequestBodyReferenceRule.class,
  io.apicurio.datamodels.validation.rules.invalid.reference.OasInvalidResponseReferenceRule.class,
  io.apicurio.datamodels.validation.rules.invalid.reference.OasInvalidSchemaReferenceRule.class,
  io.apicurio.datamodels.validation.rules.invalid.reference.OasInvalidSecurityRequirementNameRule.class,
  io.apicurio.datamodels.validation.rules.invalid.reference.OasInvalidSecuritySchemeReferenceRule.class,
  io.apicurio.datamodels.validation.rules.invalid.type.OasInvalidPropertyTypeValidationRule.class,
  io.apicurio.datamodels.validation.rules.invalid.type.OasInvalidSchemaArrayItemsRule.class,
  io.apicurio.datamodels.validation.rules.invalid.type.OasInvalidSchemaTypeValueRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasAllowReservedNotAllowedForParamRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasAllowReservedNotAllowedRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasEncodingStyleNotAllowedRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasExplodeNotAllowedRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasFormDataParamNotAllowedRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasInvalidApiConsumesMTRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasInvalidApiProducesMTRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasInvalidApiSchemeRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasInvalidEncodingForMPMTRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasInvalidHeaderStyleRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasInvalidHttpSecuritySchemeTypeRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasInvalidLinkOperationIdRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasInvalidOperationIdRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasInvalidOperationSchemeRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasInvalidSecurityReqScopesRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasMissingPathParamDefinitionRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasMissingResponseForOperationRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasOperationSummaryTooLongRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasPathParamNotFoundRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasRequiredParamWithDefaultValueRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasSecurityRequirementScopesMustBeEmptyRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasServerVarNotFoundInTemplateRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedArrayCollectionFormatRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedHeaderCollectionFormatRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedHeaderUsageRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedNumOfParamMTsRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedNumberOfHeaderMTsRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedParamAllowEmptyValueRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedParamCollectionFormatRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedParamMultiRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedRequestBodyRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedSecurityRequirementScopesRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedUsageOfBearerTokenRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedUsageOfDiscriminatorRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnexpectedXmlWrappingRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownApiKeyLocationRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownArrayCollectionFormatRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownArrayFormatRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownArrayTypeRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownCookieParamStyleRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownEncodingStyleRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownHeaderCollectionFormatRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownHeaderFormatRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownHeaderParamStyleRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownHeaderTypeRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownOauthFlowTypeRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownParamCollectionFormatRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownParamFormatRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownParamLocationRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownParamStyleRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownParamTypeRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownPathParamStyleRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownQueryParamStyleRule.class,
  io.apicurio.datamodels.validation.rules.invalid.value.OasUnknownSecuritySchemeTypeRule.class,
  io.apicurio.datamodels.validation.rules.mutex.OasBodyAndFormDataMutualExclusivityRule.class,
  io.apicurio.datamodels.validation.rules.mutex.OasExampleValueMutualExclusivityRule.class,
  io.apicurio.datamodels.validation.rules.mutex.OasHeaderExamplesMutualExclusivityRule.class,
  io.apicurio.datamodels.validation.rules.mutex.OasHeaderSchemaContentMutualExclusivityRule.class,
  io.apicurio.datamodels.validation.rules.mutex.OasLinkOperationRefMutualExclusivityRule.class,
  io.apicurio.datamodels.validation.rules.mutex.OasMediaTypeExamplesMutualExclusivityRule.class,
  io.apicurio.datamodels.validation.rules.mutex.OasParameterExamplesMutualExclusivityRule.class,
  io.apicurio.datamodels.validation.rules.mutex.OasParameterSchemaContentMutualExclusivityRule.class,
  io.apicurio.datamodels.validation.rules.other.OasBodyParameterUniquenessValidationRule.class,
  io.apicurio.datamodels.validation.rules.other.OasIgnoredContentTypeHeaderRule.class,
  io.apicurio.datamodels.validation.rules.other.OasIgnoredHeaderParameterRule.class,
  io.apicurio.datamodels.validation.rules.other.OasOperationIdUniquenessValidationRule.class,
  io.apicurio.datamodels.validation.rules.other.OasParameterUniquenessValidationRule.class,
  io.apicurio.datamodels.validation.rules.other.OasUnknownPropertyRule.class,
  io.apicurio.datamodels.validation.rules.other.SecurityRequirementUniquenessValidationRule.class,
  io.apicurio.datamodels.validation.rules.other.TagUniquenessValidationRule.class,
  io.apicurio.datamodels.validation.rules.required.AaMissingCorrelationIdRule.class,
  io.apicurio.datamodels.validation.rules.required.AasMissingServerProtocolRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingApiKeySchemeParamLocationRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingApiKeySchemeParamNameRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingApiTitleRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingApiVersionRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingHttpSecuritySchemeTypeRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingLicenseNameRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingOAuthFlowAuthUrlRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingOAuthFlowRokenUrlRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingOAuthFlowScopesRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingOAuthSecuritySchemeFlowsRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingOpenIdConnectSecuritySchemeConnectUrlRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingOperationDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingOperationIdRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingOperationSummaryRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingSecuritySchemeTypeRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingServerTemplateUrlRule.class,
  io.apicurio.datamodels.validation.rules.required.MissingTagNameRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingApiInformationRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingApiPathsRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingBodyParameterSchemaRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingDiscriminatorPropertyNameRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingExternalDocumentationUrlRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingHeaderArrayInformationRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingHeaderTypeRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingItemsArrayInformationRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingItemsTypeRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingOAuthSchemeAuthUrlRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingOAuthSchemeFlowTypeRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingOAuthSchemeScopesRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingOAuthSchemeTokenUrlRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingOpenApiPropertyRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingOperationResponsesRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingOperationTagsRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingParameterArrayTypeRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingParameterLocationRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingParameterNameRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingParameterTypeRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingRequestBodyContentRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingResponseDefinitionDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingResponseDescriptionRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingSchemaArrayInformationRule.class,
  io.apicurio.datamodels.validation.rules.required.OasMissingServerVarDefaultValueRule.class,
  io.apicurio.datamodels.validation.rules.required.OasPathParamsMustBeRequiredRule.class

})
public class ApicurioRegisterForReflection {

}
