package io.apicurio.registry.operator;

public class EnvironmentVariables {
    public static final String JAVA_OPTS_APPEND = "JAVA_OPTS_APPEND";

    public static final String QUARKUS_PROFILE = "QUARKUS_PROFILE";
    public static final String QUARKUS_HTTP_ACCESS_LOG_ENABLED = "QUARKUS_HTTP_ACCESS_LOG_ENABLED";
    public static final String QUARKUS_HTTP_CORS_ORIGINS = "QUARKUS_HTTP_CORS_ORIGINS";

    public static final String  QUARKUS_HTTP_INSECURE_REQUESTS = "QUARKUS_HTTP_INSECURE_REQUESTS";
    public static final String QUARKUS_TLS_KEY_STORE_P12_PATH = "QUARKUS_TLS_KEY_STORE_P12_PATH";
    public static final String QUARKUS_TLS_KEY_STORE_P12_PASSWORD = "QUARKUS_TLS_KEY_STORE_P12_PASSWORD";
    public static final String QUARKUS_TLS_TRUST_STORE_P12_PATH = "QUARKUS_TLS_TRUST_STORE_P12_PATH";
    public static final String QUARKUS_TLS_TRUST_STORE_P12_PASSWORD = "QUARKUS_TLS_TRUST_STORE_P12_PASSWORD";
    public static final String APICURIO_REST_DELETION_ARTIFACT_VERSION_ENABLED = "APICURIO_REST_DELETION_ARTIFACT-VERSION_ENABLED";
    public static final String APICURIO_REST_DELETION_ARTIFACT_ENABLED = "APICURIO_REST_DELETION_ARTIFACT_ENABLED";
    public static final String APICURIO_REST_DELETION_GROUP_ENABLED = "APICURIO_REST_DELETION_GROUP_ENABLED";

    private static final String KAFKA_PREFIX = "APICURIO_KAFKA_COMMON_";
    public static final String KAFKASQL_SECURITY_PROTOCOL = KAFKA_PREFIX + "SECURITY_PROTOCOL";
    public static final String KAFKASQL_SSL_KEYSTORE_TYPE = KAFKA_PREFIX + "SSL_KEYSTORE_TYPE";
    public static final String KAFKASQL_SSL_KEYSTORE_LOCATION = KAFKA_PREFIX + "SSL_KEYSTORE_LOCATION";
    public static final String KAFKASQL_SSL_KEYSTORE_PASSWORD = KAFKA_PREFIX + "SSL_KEYSTORE_PASSWORD";
    public static final String KAFKASQL_SSL_TRUSTSTORE_TYPE = KAFKA_PREFIX + "SSL_TRUSTSTORE_TYPE";
    public static final String KAFKASQL_SSL_TRUSTSTORE_LOCATION = KAFKA_PREFIX + "SSL_TRUSTSTORE_LOCATION";
    public static final String KAFKASQL_SSL_TRUSTSTORE_PASSWORD = KAFKA_PREFIX + "SSL_TRUSTSTORE_PASSWORD";

    // KafkaSQL oauth
    public static final String APICURIO_KAFKASQL_SECURITY_SASL_ENABLED = "APICURIO_KAFKASQL_SECURITY_SASL_ENABLED";
    public static final String APICURIO_KAFKASQL_SECURITY_SASL_MECHANISM = "APICURIO_KAFKASQL_SECURITY_SASL_MECHANISM";
    public static final String APICURIO_KAFKASQL_SECURITY_SASL_CLIENT_ID = "APICURIO_KAFKASQL_SECURITY_SASL_CLIENT_ID";
    public static final String APICURIO_KAFKASQL_SECURITY_SASL_CLIENT_SECRET = "APICURIO_KAFKASQL_SECURITY_SASL_CLIENT_SECRET";
    public static final String APICURIO_KAFKASQL_SECURITY_SASL_TOKEN_ENDPOINT = "APICURIO_KAFKASQL_SECURITY_SASL_TOKEN_ENDPOINT";
    public static final String APICURIO_KAFKASQL_SECURITY_SASL_LOGIN_CALLBACK_HANDLER_CLASS = "APICURIO_KAFKASQL_SECURITY_SASL_LOGIN_CALLBACK_HANDLER_CLASS";

    // Auth related environment variables
    public static final String APICURIO_REGISTRY_AUTH_ENABLED = "QUARKUS_OIDC_TENANT_ENABLED";
    public static final String APICURIO_REGISTRY_APP_CLIENT_ID = "QUARKUS_OIDC_CLIENT_ID";
    public static final String APICURIO_REGISTRY_UI_CLIENT_ID = "APICURIO_UI_AUTH_OIDC_CLIENT_ID";
    public static final String APICURIO_UI_AUTH_OIDC_REDIRECT_URI = "APICURIO_UI_AUTH_OIDC_REDIRECT_URI";
    public static final String APICURIO_UI_AUTH_OIDC_LOGOUT_URL = "APICURIO_UI_AUTH_OIDC_LOGOUT_URL";
    public static final String APICURIO_REGISTRY_AUTH_SERVER_URL = "QUARKUS_OIDC_AUTH_SERVER_URL";
    public static final String OIDC_TLS_VERIFICATION = "QUARKUS_OIDC_TLS_VERIFICATION";
    public static final String OIDC_TLS_TRUSTSTORE_LOCATION = "QUARKUS_OIDC_TLS_TRUST_STORE_FILE";
    public static final String OIDC_TLS_TRUSTSTORE_PASSWORD = "QUARKUS_OIDC_TLS_TRUST_STORE_PASSWORD";

    public static final String APICURIO_AUTHN_BASIC_CLIENT_CREDENTIALS_ENABLED = "APICURIO_AUTHN_BASIC_CLIENT_CREDENTIALS_ENABLED";
    public static final String APICURIO_AUTHN_BASIC_CLIENT_CREDENTIALS_CACHE_EXPIRATION = "APICURIO_AUTHN_BASIC_CLIENT_CREDENTIALS_CACHE_EXPIRATION";
    public static final String APICURIO_AUTH_ANONYMOUS_READ_ACCESS_ENABLED = "APICURIO_AUTH_ANONYMOUS_READ_ACCESS_ENABLED";

    // Authz related environment variables
    public static final String APICURIO_AUTH_ROLE_BASED_AUTHORIZATION = "APICURIO_AUTH_ROLE_BASED_AUTHORIZATION";
    public static final String APICURIO_AUTH_AUTHENTICATED_READ_ACCESS_ENABLED = "APICURIO_AUTH_AUTHENTICATED_READ_ACCESS_ENABLED";
    public static final String APICURIO_AUTH_OWNER_ONLY_AUTHORIZATION_LIMIT_GROUP_ACCESS = "APICURIO_AUTH_OWNER_ONLY_AUTHORIZATION_LIMIT_GROUP_ACCESS";
    public static final String APICURIO_AUTH_OWNER_ONLY_AUTHORIZATION = "APICURIO_AUTH_OWNER_ONLY_AUTHORIZATION";
    public static final String APICURIO_AUTH_ROLE_SOURCE = "APICURIO_AUTH_ROLE_SOURCE";
    public static final String APICURIO_AUTH_ROLES_ADMIN = "APICURIO_AUTH_ROLES_ADMIN";
    public static final String APICURIO_AUTH_ROLES_DEVELOPER = "APICURIO_AUTH_ROLES_DEVELOPER";
    public static final String APICURIO_AUTH_ROLES_READONLY = "APICURIO_AUTH_ROLES_READONLY";
    public static final String APICURIO_AUTH_ADMIN_OVERRIDE_ENABLED = "APICURIO_AUTH_ADMIN_OVERRIDE_ENABLED";
    public static final String APICURIO_AUTH_ADMIN_OVERRIDE_ROLE = "APICURIO_AUTH_ADMIN_OVERRIDE_ROLE";
    public static final String APICURIO_AUTH_ADMIN_OVERRIDE_FROM = "APICURIO_AUTH_ADMIN_OVERRIDE_FROM";
    public static final String APICURIO_AUTH_ADMIN_OVERRIDE_TYPE = "APICURIO_AUTH_ADMIN_OVERRIDE_TYPE";
    public static final String APICURIO_AUTH_ADMIN_OVERRIDE_CLAIM = "APICURIO_AUTH_ADMIN_OVERRIDE_CLAIM";
    public static final String APICURIO_AUTH_ADMIN_OVERRIDE_CLAIM_VALUE = "APICURIO_AUTH_ADMIN_OVERRIDE_CLAIM_VALUE";
}
