package io.apicurio.tests.utils;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;

@ExtendWith(ExtensionContextParameterResolver.class)
public interface TestSeparator {
    Logger SEPARATOR_LOGGER = LoggerFactory.getLogger(TestSeparator.class);
    String SEPARATOR_CHAR = "#";

    @BeforeEach
    default void beforeEachTest(TestInfo testInfo) {
        SEPARATOR_LOGGER.info(String.join("", Collections.nCopies(76, SEPARATOR_CHAR)));
        SEPARATOR_LOGGER.info(String.format("%s.%s-STARTED", testInfo.getTestClass().get().getName(),
                testInfo.getTestMethod().get().getName()));
    }

    @AfterEach
    default void afterEachTest(TestInfo testInfo) {
        SEPARATOR_LOGGER.info(String.format("%s.%s-FINISHED", testInfo.getTestClass().get().getName(),
                testInfo.getTestMethod().get().getName()));
        SEPARATOR_LOGGER.info(String.join("", Collections.nCopies(76, SEPARATOR_CHAR)));
    }
}