package org.optaplanner.core.impl.heuristic.selector;

import java.util.Spliterator;
import java.util.Spliterators;

import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;

public interface IterableSelector<Solution_, T> extends Selector<Solution_>, Iterable<T> {

    /**
     * A random JIT {@link Selector} with {@link #isNeverEnding()} true should return a size
     * as if it would be able to return each distinct element only once,
     * because the size can be used in {@link SelectionProbabilityWeightFactory}.
     *
     * @return the approximate number of elements generated by this {@link Selector}, always {@code >= 0}
     * @throws IllegalStateException if {@link #isCountable} returns false,
     *         but not if only {@link #isNeverEnding()} returns true
     */
    long getSize();

    @Override
    default Spliterator<T> spliterator() {
        if (isCountable()) {
            return Spliterators.spliterator(iterator(), getSize(), Spliterator.ORDERED);
        } else {
            return Iterable.super.spliterator();
        }
    }
}
