/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.messaging.core.impl.postoffice.ClusterRequest;
import org.jboss.messaging.core.impl.postoffice.RequestTarget;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

public class GetReplicatedDeliveriesRequest
extends ClusterRequest {
    private String queueName;
    private Address returnAddress;

    public GetReplicatedDeliveriesRequest() {
    }

    public GetReplicatedDeliveriesRequest(String queueName, Address returnAddress) {
        this.queueName = queueName;
        this.returnAddress = returnAddress;
    }

    Object execute(RequestTarget office) throws Throwable {
        office.handleGetReplicatedDeliveries(this.queueName, this.returnAddress);
        return null;
    }

    byte getType() {
        return 13;
    }

    public void read(DataInputStream in) throws Exception {
        this.queueName = in.readUTF();
        byte b = in.readByte();
        if (b != 0) {
            this.returnAddress = new IpAddress();
            this.returnAddress.readFrom(in);
        }
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeUTF(this.queueName);
        if (this.returnAddress == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            if (!(this.returnAddress instanceof IpAddress)) {
                throw new IllegalStateException("Address must be IpAddress");
            }
            this.returnAddress.writeTo(out);
        }
    }
}

