package org.drools.workbench.jcr2vfsmigration.migrater;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.httpclient.util.URIUtil;
import org.drools.workbench.models.commons.backend.imports.ImportsParser;
import org.drools.workbench.models.commons.backend.packages.PackageNameParser;
import org.drools.workbench.models.commons.backend.packages.PackageNameWriter;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.packages.HasPackageName;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ProjectService;
import org.uberfire.backend.vfs.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PackageImportHelper {

    @Inject
    private ProjectService projectService;

    @Inject
    private PackageHeaderInfo packageHeaderInfo;

    //Check if the xml contains a Package declaration, appending one if it does not exist
    public String assertPackageNameXML( final String xml,
                                        final Path resource ) {
        final Package pkg = projectService.resolvePackage( resource );
        String pkName =null;
        try{
            pkName =pkg.getPackageName();

            if(pkName!=null && pkg.getPackageName().endsWith(URIUtil.decode(resource.getFileName()))){
                pkName = pkg.getPackageName().substring(0,pkg.getPackageName().indexOf(URIUtil.decode(resource.getFileName()))-1);
            }
        }catch (Exception e){
        }
        final String requiredPackageName = pkName;

        if ( requiredPackageName == null || "".equals( requiredPackageName ) ) {
            return xml;
        }

        DocumentBuilderFactory domfac = DocumentBuilderFactory.newInstance();

        try {
            DocumentBuilder dombuilder = domfac.newDocumentBuilder();

            Document doc = dombuilder.parse( new ByteArrayInputStream( xml.getBytes() ) );

            if ( doc.getElementsByTagName( "packageName" ).getLength() != 0 ) {
                return xml;
            }

            Element root = doc.getDocumentElement();
//            Element nameElement = doc.createElement( "name" );
//            nameElement.appendChild( doc.createTextNode( resource.getFileName()) );
//            root.appendChild( nameElement );

            Element packageElement = doc.createElement( "packageName" );
            packageElement.appendChild( doc.createTextNode( requiredPackageName ) );
            root.appendChild( packageElement );

            //output xml with pretty format
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty( OutputKeys.METHOD, "xml" );
            trans.setOutputProperty( OutputKeys.INDENT, "yes" );
            trans.setOutputProperty( "{http://xml.apache.org/xslt}indent-amount", Integer.toString( 2 ) );

            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult( sw );
            DOMSource s = new DOMSource( root );

            trans.transform( s, result );
            String xmlString = sw.toString();
            if(xmlString!=null)
                xmlString =xmlString.substring(xmlString.indexOf("\n")+1);
            return xmlString;
        } catch ( TransformerConfigurationException e ) {
            e.printStackTrace();
        } catch ( ParserConfigurationException e ) {
            e.printStackTrace();
        } catch ( FileNotFoundException e ) {
            e.printStackTrace();
        } catch ( SAXException e ) {
            e.printStackTrace();
        } catch ( IOException e ) {
            e.printStackTrace();
        } catch ( TransformerException e ) {
            e.printStackTrace();
        }

        return xml;
    }

    public String assertPackageImportDRL( final String drl,
                                          final Path resource ) {
        if ( packageHeaderInfo.getHeader() == null ) {
            return drl;
        }

        final Imports imports = ImportsParser.parseImports( packageHeaderInfo.getHeader() );
        if ( imports == null ) {
            return drl;
        }
        StringBuilder sb = new StringBuilder();
        sb.append( imports.toString() );
        if ( imports.getImports().size() > 0 ) {
            sb.append( "\n" );
        }

        sb.append( drl );
        return sb.toString();
    }

    public String assertPackageImportXML( final String xml,
                                          final Path resource ) {
        if ( packageHeaderInfo.getHeader() == null ) {
            return xml;
        }

        final Imports imports = ImportsParser.parseImports( packageHeaderInfo.getHeader() );
        if ( imports == null ) {
            return xml;
        }

        DocumentBuilderFactory domfac = DocumentBuilderFactory.newInstance();

        try {
            DocumentBuilder dombuilder = domfac.newDocumentBuilder();
            Document doc = dombuilder.parse( new ByteArrayInputStream( xml.getBytes() ) );

            if ( doc.getElementsByTagName( "imports" ).getLength() != 0 ) {
                return xml;
            }

            Element root = doc.getDocumentElement();
            Element importsElement = doc.createElement( "imports" );
            if(imports!=null && imports.getImports().size()==0){
                Element defaultImportElement = doc.createElement( "imports" );
                importsElement.appendChild(defaultImportElement);
            }

            for ( final Import i : imports.getImports() ) {
                Element importElement = doc.createElement( "import" );
                importElement.appendChild( doc.createTextNode( i.getType() ) );
                importsElement.appendChild( importElement );
            }


            root.appendChild( importsElement );

            //output xml with pretty format
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty( OutputKeys.METHOD, "xml" );
            trans.setOutputProperty( OutputKeys.INDENT, "yes" );
            trans.setOutputProperty( "{http://xml.apache.org/xslt}indent-amount", Integer.toString( 2 ) );

            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult( sw );
            DOMSource s = new DOMSource( root );

            trans.transform( s, result );
            String xmlString = sw.toString();
            if(xmlString!=null)
                xmlString =xmlString.substring(xmlString.indexOf("\n")+1);
            return xmlString;
        } catch ( TransformerConfigurationException e ) {
            e.printStackTrace();
        } catch ( ParserConfigurationException e ) {
            e.printStackTrace();
        } catch ( FileNotFoundException e ) {
            e.printStackTrace();
        } catch ( SAXException e ) {
            e.printStackTrace();
        } catch ( IOException e ) {
            e.printStackTrace();
        } catch ( TransformerException e ) {
            e.printStackTrace();
        }

        return xml;
    }

    public String assertPackageName( final String drl,
                                     final Path resource ) {
        try {
            final String existingPackageName = PackageNameParser.parsePackageName(drl);
            if ( !"".equals( existingPackageName ) ) {
                return drl;
            }

            final Package pkg = projectService.resolvePackage( resource );
            String pkName =pkg.getPackageName();
            try{
                if(pkName!=null && pkg.getPackageName().endsWith(URIUtil.decode(resource.getFileName()))){
                    pkName = pkg.getPackageName().substring(0,pkg.getPackageName().indexOf(URIUtil.decode(resource.getFileName()))-1);
                }
            }catch (Exception e){

            }
            final String requiredPackageName = pkName;

            final HasPackageName mockHasPackageName = new HasPackageName() {

                @Override
                public String getPackageName() {
                    return requiredPackageName;
                }

                @Override
                public void setPackageName( final String packageName ) {
                    //Nothing to do here
                }
            };
            final StringBuilder sb = new StringBuilder();
            PackageNameWriter.write(sb,
                    mockHasPackageName);
            sb.append( drl );
            return sb.toString();

        } catch ( Exception e ) {
            throw ExceptionUtilities.handleException(e);
        }
    }
}
