package com.redhat.installer.postinstall;

import org.jboss.as.cli.CliInitializationException;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.util.ServerCommandsHelper;

import java.io.File;
public class CliScriptHelper {
    private static final String RESOLVE_PARAMS = "resolve-params";
    // ServerCommands to run the commands with
    private static ArgumentParser parser;
    private static ServerCommands serverCommands;
	private static AutomatedInstallData idata;
	private static AbstractUIProcessHandler mHandler;

	// general info
	private static String[] cliScripts;
	
	public static boolean run(AbstractUIProcessHandler handler, String[]args) throws Exception{
		idata = AutomatedInstallData.getInstance();
		mHandler = handler;
		cliScripts = args;
        parser = new ArgumentParser();
        parser.parse(args);
        if (parser.hasProperty(RESOLVE_PARAMS)){
            cliScripts = new String[args.length-1];
            //assume that the property is specified first
            for (int i = 1; i < args.length; i++){
                cliScripts[i-1] = args[i];
            }
        } else {
		    cliScripts = args;
        }
		
        for (String script : cliScripts){
            File check = new File(script);
            if (!check.exists()){
                ProcessPanelHelper.printToPanel(mHandler, String.format("Script %s does not exist.", script), true);
                return false;
            }
        }
		init();
		ServerCommandsHelper.connectContext(handler, serverCommands);
		
		for (int i = 0; i < cliScripts.length; i++){
			// for each script, we load all of the commands and save the batch with the value of i
			serverCommands.createNewBatch();
			serverCommands.runCommandsInFile(cliScripts[i]);
			serverCommands.storeCurrentBatch(String.valueOf(i));
		}
		
		
		// no need to write log when it == the file we're reading
		//serverCommands.writeLogFile();
		// clunky CommandContext stupidity
		
		for (int i = 0; i < cliScripts.length; i++){
			if (serverCommands.isStoredBatch(String.valueOf(i))){
				if (serverCommands.runBatch(String.valueOf(i)) == 0){
					//ProcessPanelHelper.printToPanel(mHandler, String.format("Script %s ran successfully.", cliScripts[i]), false);
                    ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("CliScriptHelper.success"), cliScripts[i]), false);
				} else {
					//ProcessPanelHelper.printToPanel(mHandler, String.format("Script %s failed to run.", cliScripts[i]), true);
                    ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("CliScriptHelper.failure"), cliScripts[i]), true);
					return false; // fail the installation fast
				}
			}
		}
		serverCommands.terminateSession();
		return true; // success
	}
	
	private static void init(){
		String username = idata.getVariable("postinstall.username");
		char[] password = idata.getVariable("postinstall.password").toCharArray();		
		serverCommands = null;
		
		int port = ServerManager.getManagementPort();

		try {
			serverCommands = ServerCommands.createSession(username, password, port);

            if (parser.hasProperty(RESOLVE_PARAMS)){
                String resolution = parser.getProperty(RESOLVE_PARAMS);
                serverCommands.setResolveParameterValues(Boolean.parseBoolean(resolution));
            } else {
                serverCommands.setResolveParameterValues(true);
            }
		} catch (CliInitializationException e){
            e.printStackTrace();
			ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.init.error"), true);	
		}
	}
}
