#! /bin/bash

# This script is supposed to verify that an auto-installation for a given version
# of EAP SOA is correct. ie: No unexpected differences between the auto-install files
# and the verification files found in a zip in the specific installer folder.

if [ "$#" -ne 1 ]; then
  echo "Usage: $0 <path-to-jar>" >&2
  echo "Example: $0 ../target/jboss-eap-6.1.0.soa-installer.jar"
  exit 1
fi

# Full version id: 6.1.0.soa
JAR_PATH=$1
# Only the jar name
JAR_NAME=$(basename $JAR_PATH)

if [[ "$JAR_NAME" == *soa* ]]; then
    INSTALLER=soa
elif [[ "$JAR_NAME" == *brms* ]]; then
    INSTALLER=brms
elif [[ "$JAR_NAME" == *bpms* ]]; then
    INSTALLER=bpms
fi

# Major Version num: Ie: 6.1
# grab the version number from the given jarname
FULL_VER=`echo $JAR_NAME | grep -o '[0-9]\.[0-9]\.[0-9]'`
VER=`echo $FULL_VER | cut -c 1-3`

#Script directory
pushd `dirname $0` > /dev/null
TESTDIR=`pwd`
popd
#Root dir
ROOTDIR=`dirname $TESTDIR`
echo "[ Repo root directory: $ROOTDIR ]"
echo "[ Test directory: $TESTDIR ]"

# Installer dir
INSTDIR=$ROOTDIR/$INSTALLER

# Verification file:
ZIPFILE=$INSTDIR/$INSTALLER-zip/$INSTALLER*.zip

list=(
"add-user.bat",
"appclient.bat",
"appclient.conf.bat",
"domain.bat",
"domain.conf.bat",
"jboss-cli.bat",
"jconsole.bat",
"jdr.bat",
"run.bat",
"standalone.bat",
"standalone.conf.bat",
"vault.bat",
"wsconsume.bat",
"wsprovide.bat",
"jar/jboss-eap-$VER/domain/configuration/host.xml",
"jar/jboss-eap-$VER/domain/configuration/mgmt-users.properties",
"jar/jboss-eap-$VER/standalone/configuration/mgmt-users.properties",
"jar/jboss-eap-$VER/standalone/configuration/standalone.xml",
"jar/jboss-eap-$VER/standalone/configuration/standalone-full-ha.xml",
"shutdown.sh",
"shutdown.bat",
"standalone.xml.orig",
"standalone-full.xml.orig",
"standalone-ha.xml.orig",
"modifySettings.xsl",
"icons",
"Only in zip/jboss-eap-$VER/domain: data",
"Only in zip/jboss-eap-$VER/domain: tmp",
"Only in zip/jboss-eap-$VER/standalone: lib",
"Only in zip/jboss-eap-$VER/standalone: tmp",
"Only in jar/: Uninstaller",
"Only in jar/: .installationinformation",
"Only in jar/jboss-eap-6.1/bin: run.exe",
"Only in zip/jboss-eap-6.1/modules/system/layers/soa/org/modeshape/main/deployments/modeshape-rest.war/WEB-INF: classes",
"Only in zip/jboss-eap-6.1/modules/system/layers/soa/org/modeshape/main/deployments/modeshape-webdav.war/WEB-INF: classes"
)

blacklist=$(echo ${list[@]}|tr "," "|"|sed -e 's/ *| */|/g')

if [ -d "$TESTDIR/verifying" ];
then
	rm -rf $TESTDIR/verifying
fi

mkdir $TESTDIR/verifying
cd $TESTDIR/verifying

if [ ! -f $ZIPFILE ];
then
    echo $INSTALLER-*.Alpha-redhat-1.zip not found
    exit 1
fi

# Copy the EAP commmon files into this verification dir,
# then unzip the SOA specific files into it.
#mkdir zip
#mkdir zip/jboss-eap-$VER

echo "[ Extracting eap common files... ]"
# get the version of the jboss-as-dist we need from the root pom
EAPVER=$(cat $ROOTDIR/pom.xml | grep \<version.jboss.as.dist\> | sed 's#<version.jboss.as.dist>##g' | sed 's#</version.jboss.as.dist>##g' | tr -d ' ')
# get the right zip from the local maven repo (this should always exist on the
# system.)
EAPZIP=$HOME/.m2/repository/org/jboss/as/jboss-as-dist/$EAPVER/jboss-as-dist-$EAPVER.zip
#cp -r $DIR/common-files/eap-dist/jboss-eap-$VER/* zip/jboss-eap-$VER
#cp $ZIPFILE $INSTALLER.zipA
#unzip the jboss-as-dist zip to verification/zip
unzip -d zip/ -q $EAPZIP

echo "[ Extracting $INSTALLER specific files... ]"
#unzip the specific distribution zip to verification/zip, overwriting all
#conflicting files
unzip -o -d zip/ -q $ZIPFILE
#cp -rf jboss*/* zip/jboss*/
#rm -rf jboss*
#rm $INSTALLER.zip

# Run the installer on auto mode using the settings in the auto.xml.
echo "[ Auto-installing $INSTALLER... ]"
java -jar $ROOTDIR/target/$JAR_NAME $TESTDIR/auto$INSTALLER.xml

# Do a recursive diff on the contents of the jar from the auto installation
# vs the contents of the zipped installation, and ignore any of the files
# on the blacklist.
if [ ! -d "$TESTDIR/verifying/jar" ] || [ ! -d "$TESTDIR/verifying/zip" ];
then
    #this condition cannot be allowed. the unzipping or the jar installation
    #failed somehow, and thus a diff is meaningless
    echo "Either automated installation or extraction failed. See test/verifying
    for more details."
        exit 1
fi
diff -qr jar/ zip/ > diffa.log

#grep -v -w -E "$(echo $blacklist)" diffa.log > diff.log
# as different setups change, we may want different blacklists per distribution.
# use the external blacklist files for testing different distributions.
grep -v -w -E "$(cat ${TESTDIR}/${INSTALLER}blacklist.bl | sed "s/VER/$VER/g")" diffa.log > diff.log
rm diffa.log

# Verification is successful if diff, after ignoring files on the blacklist,
# found no differences between the contents of the auto-intall jar and
# the pre-made zip installs.
if [ -s "diff.log" ];
then
    echo "Verification : unsuccessful."
    echo "See ./verifying/diff.log for details."
    exit 1
else
    echo "Verification : successful."
fi
