package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.util.TomcatUtils;
import org.w3c.dom.*;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;

public class TomcatModifyServer {
    private static AbstractUIProcessHandler mHandler;
    private static AutomatedInstallData idata;

    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        mHandler = handler;
        idata = AutomatedInstallData.getInstance();
        return configureTomcatServerFile();
    }

    private static boolean configureTomcatServerFile() {
        try {
            Path tomcatServerPath = Paths.get(idata.getInstallPath(), "conf", "server.xml");
            Document xml = TomcatUtils.getXmlDocument(tomcatServerPath);
            addJACCValve(xml);
            addSecretKeyCredentialHandler(xml);
            TomcatUtils.writeXmlDocumentToFile(xml, tomcatServerPath);
        } catch (SAXException | ParserConfigurationException | IOException | TransformerException | XPathExpressionException e) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.serverfile.failed"), true);
            ProcessPanelHelper.printExceptionToLog(e.getStackTrace());
            return false;
        }
        ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.serverfile.success"), false);
        return true;
    }

    private static void addSecretKeyCredentialHandler(Document xml) {
        NodeList existingRealms = xml.getElementsByTagName("Realm");
        Node realm = TomcatUtils.findNodeWithAttribute(existingRealms, "className", "org.apache.catalina.realm.UserDatabaseRealm");
        if (realm != null && !existingCredentialHandler(realm)) {
            Comment comment = TomcatUtils.createInstallerComment(xml);
            realm.appendChild(comment);
            Element credentialHandler = xml.createElement("CredentialHandler");
            credentialHandler.setAttribute("className", "org.apache.catalina.realm.SecretKeyCredentialHandler");
            credentialHandler.setAttribute("algorithm", "PBKDF2WithHmacSHA512");
            credentialHandler.setAttribute("keyLength", "256");
            realm.appendChild(credentialHandler);
        }
    }

    private static boolean existingCredentialHandler(Node realm) {
        NodeList realmChildren = realm.getChildNodes();
        for (int i = 0; i < realmChildren.getLength(); i++) {
            Node child = realmChildren.item(i);

            if (child.getNodeName().equals("CredentialHandler")) {
                return true;
            }
        }
        return false;
    }

    private static void addJACCValve(Document xml) {
        NodeList existingHosts = xml.getElementsByTagName("Host");
        for (int i = 0; i < existingHosts.getLength(); i++) {
            Node host = existingHosts.item(i);
            if (host.hasAttributes() && host.getAttributes().getNamedItem("name").getNodeValue().equals("localhost")) {
                Comment comment = TomcatUtils.createInstallerComment(xml);
                host.appendChild(comment);
                Element valve = xml.createElement("Valve");
                valve.setAttribute("className", "org.kie.integration.tomcat.JACCValve");
                host.appendChild(valve);
                return;
            }
        }
        // need better error handling in this case
        ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.serverfile.hostnotfound"), true);
    }
}

