/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.screens.archetype.mgmt.client.resources.i18n;

import org.jboss.errai.ui.shared.api.annotations.TranslationKey;

public interface ArchetypeManagementConstants {

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_ArchetypeManagementPerspectiveName = "ArchetypeManagement.ArchetypeManagementPerspectiveName";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_AddArchetype = "ArchetypeManagement.AddArchetype";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_Add = "ArchetypeManagement.Add";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_Delete = "ArchetypeManagement.Delete";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_Cancel = "ArchetypeManagement.Cancel";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_Loading = "ArchetypeManagement.Loading";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_Search = "ArchetypeManagement.Search";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_EmptyFieldValidation = "ArchetypeManagement.EmptyFieldValidation";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_ArchetypeAddedMessage = "ArchetypeManagement.ArchetypeAddedMessage";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_ArchetypeDeletedMessage = "ArchetypeManagement.ArchetypeDeletedMessage";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_ArchetypeValidatedMessage = "ArchetypeManagement.ArchetypeValidatedMessage";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_ArchetypeAlreadyExistsMessage = "ArchetypeManagement.ArchetypeAlreadyExistsMessage";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_MavenExecutionExceptionMessage = "ArchetypeManagement.MavenExecutionExceptionMessage";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_InvalidArchetypeExceptionMessage = "ArchetypeManagement.InvalidArchetypeExceptionMessage";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_DeleteArchetypeTitle = "ArchetypeManagement.DeleteArchetypeTitle";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_DeleteArchetypeMessage = "ArchetypeManagement.DeleteArchetypeMessage";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_OfN = "ArchetypeManagement.OfN";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_ItemCountIndicatorText = "ArchetypeManagement.ItemCountIndicatorText";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_IncludeTooltip = "ArchetypeManagement.IncludeTooltip";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_GroupIdTooltip = "ArchetypeManagement.GroupIdTooltip";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_ArtifactIdTooltip = "ArchetypeManagement.ArtifactIdTooltip";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_VersionTooltip = "ArchetypeManagement.VersionTooltip";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_CreatedDateTooltip = "ArchetypeManagement.CreatedDateTooltip";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_StatusTooltip = "ArchetypeManagement.StatusTooltip";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_ActionsTooltip = "ArchetypeManagement.ActionsTooltip";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_SelectionCounter = "ArchetypeManagement.SelectionCounter";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_ValidMessage = "ArchetypeManagement.ValidMessage";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_InvalidMessage = "ArchetypeManagement.InvalidMessage";

    @TranslationKey(defaultValue = "")
    String ArchetypeManagement_DefaultMessage = "ArchetypeManagement.DefaultMessage";

    @TranslationKey(defaultValue = "")
    String ArchetypeGroupId = "ArchetypeGroupId";

    @TranslationKey(defaultValue = "")
    String ArchetypeArtifactId = "ArchetypeArtifactId";

    @TranslationKey(defaultValue = "")
    String ArchetypeVersion = "ArchetypeVersion";
}