package com.redhat.installer.tests.installation.processpanel;

import com.redhat.installer.framework.mock.MockResourceBuilder;
import com.redhat.installer.framework.testers.ProcessPanelTester;
import com.redhat.installer.installation.processpanel.TomcatAddRoles;
import com.redhat.installer.tests.TestUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import static junit.framework.TestCase.assertFalse;
import static junit.framework.TestCase.assertTrue;

public class TomcatAddRolesTest extends ProcessPanelTester {

    private final String existingUsersXml = "/tomcat/tomcat-users.xml";
    private final String noExistingUsersXml = "/tomcat/tomcat-users-noexisting.xml";
    private final String copiedXml = "/conf/tomcat-users.xml";
    private final String roleTemplate = "<role rolename=\"%s\"/>";
    private final String testUsername = "testerinousername";
    private final String testPassword = "passw*rd1!";
    private final String testRoleList = "rolelisttest";
    private final String[] testArgs = new String[]{testUsername, testPassword, testRoleList};
    private static List<String> kieRoles;

    static {
        // should these be the same as for EAP?
        kieRoles = new ArrayList<>();
        kieRoles.add("admin");
        kieRoles.add("kie-server");
        kieRoles.add("rest-all");
        kieRoles.add("analyst");
        kieRoles.add("developer");
        kieRoles.add("user");
        kieRoles.add("manager");
        kieRoles.add("process-admin");
    }


    @Before
    public void setUp() throws Exception {
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "", "");
    }

    @After
    public void cleanup() throws Exception {
        if (Files.exists(Paths.get(idata.getInstallPath() + copiedXml))) {
            MockResourceBuilder.deleteFile(idata.getInstallPath() + copiedXml);
        }
    }

    @Test
    public void testSuccessExistingUsers() throws Exception {
        MockResourceBuilder.copyResourceToInstall(existingUsersXml, idata.getInstallPath() + copiedXml);
        boolean result = TomcatAddRoles.run(handler, testArgs);
        assertCorrect(result);
    }

    @Test
    public void testNoExistingUsers() throws Exception {
        MockResourceBuilder.copyResourceToInstall(noExistingUsersXml, idata.getInstallPath() + copiedXml);
        boolean result = TomcatAddRoles.run(handler, testArgs);
        assertCorrect(result);
    }

    @Test
    public void testNoFileDetected() throws Exception {
        boolean result = TomcatAddRoles.run(handler, testArgs);
        assertFalse(result);
    }

    private void assertCorrect(boolean runResult) throws Exception {
        assertTrue(runResult);
        String newFileString = Files.lines(Paths.get(tempFolder.getRoot().getPath() + copiedXml)).collect(Collectors.joining("\n"));
        // check that the base tags are unmodified
        Document modifiedXml = Jsoup.parse(newFileString, "", Parser.xmlParser());
        Elements tomcatUsersElement = modifiedXml.getElementsByTag("tomcat-users");
        assertFalse(tomcatUsersElement.isEmpty());
        // all roles are added.
        for (String role : kieRoles) {
            assertTrue(newFileString.contains(String.format(roleTemplate, role)));
        }
    }
}
