package com.redhat.installer.asconfiguration.datasource.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.UserInputPanel;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.PasswordEqualityValidator;
import com.redhat.installer.asconfiguration.jdbc.constant.JBossJDBCConstants;
import com.redhat.installer.asconfiguration.jdbc.validator.JDBCConnectionUtils;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;

/**
 * Created by aabulawi on 01/06/15.
 */
public class DatasourceConnectionValidator implements Validator, DataValidator {

    private String message;
    private String warning;
    private AutomatedInstallData idata;

    private boolean isSecurityDomain(AutomatedInstallData idata) {
        return idata.getVariable("JBossDatasourceConfigPanel.securitytype.value").equals("Security-domain");
    }

    //Used through test button of userInputPanel
    public Validator.Status validate(ProcessingClient client) {
        Validator.Status failureStatus = Validator.Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get(WARNING_PARAM)))
            failureStatus = Validator.Status.WARNING;
        idata = AutomatedInstallData.getInstance();
        if (!validatePasswordField(client)) {
            return failureStatus;
        }
        AutomatedInstallData adata = AutomatedInstallData.getInstance();

        String driverClassName = adata.getVariable("jdbc.driver.name");
        String username = adata.getVariable("jdbc.datasource.username");
        String password = adata.getVariable("jdbc.datasource.password");
        String connectionUrl = adata.getVariable("jdbc.datasource.connectionurl");

        if (driverClassName != null) {
            Object[] jarPaths = JDBCConnectionUtils.readIdataForJarPaths("jdbc.driver.jar").toArray();
            Class driverClass = JDBCConnectionUtils.findDriverClass(JBossJDBCConstants.classnameMap.get(driverClassName), JDBCConnectionUtils.convertToUrlArray(jarPaths));

            if (isSecurityDomain(adata)) {
                setWarningMessageId("DatabaseLoggingConnectionValidator.connection.failed");
                return failureStatus;
            }

            Driver driverInstance = null;

            try {
                driverInstance = (Driver) driverClass.newInstance();
            } catch (InstantiationException e) {

                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }

            Object jdbcConnection = JDBCConnectionUtils.getDatabaseConnection(driverInstance, username, password, connectionUrl);

            if (jdbcConnection != null) {
                if (jdbcConnection.getClass().equals(String.class)) {
                    setWarningMessageId("DatabaseLoggingConnectionValidator.connection.failed");
                    return failureStatus;
                }
                try {
                    ((Connection) jdbcConnection).close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
                return Validator.Status.OK;
            } else {
                setWarningMessageId("DatabaseLoggingConnectionValidator.connection.failed");
                return failureStatus;
            }
        } else {
            return failureStatus;
        }
    }

    private boolean validatePasswordField(ProcessingClient client) {
        PasswordGroup toTest = (PasswordGroup) client;
        if (toTest.getGroupName() != null && !toTest.getGroupName().isEmpty()) {
            PasswordEqualityValidator pev = new PasswordEqualityValidator();
            UserInputPanel uip = (UserInputPanel) idata.panels.get(idata.curPanelNumber);
            PasswordGroup processingClient = uip.getPasswordGroups().get(toTest.getGroupName());
            if (pev.validate(processingClient) != Validator.Status.OK) {
                setWarningMessageId("username.no.match.password");
                message = AutomatedInstallData.getInstance().langpack.getString(warning);
                return false;
            }
        }
        return true;
    }

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return warning;
    }

    @Override
    public String getWarningMessageId() {
        return warning;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return message;
    }

    public void setWarningMessageId(String id) {
        warning = id;
    }
}
