package com.redhat.installer.tests.installation.processpanel;

import com.redhat.installer.framework.constants.CommonStrings;
import com.redhat.installer.framework.mock.MockInstallerStructure;
import com.redhat.installer.framework.mock.MockResourceBuilder;
import com.redhat.installer.framework.testers.ProcessPanelTester;
import com.redhat.installer.installation.processpanel.TextReplacer;
import com.redhat.installer.tests.TestUtils;
import org.junit.Before;
import org.junit.Test;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;

import static junit.framework.TestCase.assertEquals;
import static junit.framework.TestCase.assertTrue;


public class TextReplacerTest extends ProcessPanelTester implements CommonStrings {
    private final String testFileName = "testfile.txt";
    private final String testFilePath = "/textreplacer/"+testFileName;
    private String copiedFile;

    @Before
    public void setUp() throws Exception {
        MockInstallerStructure.createDefaultDirectories(tempFolder, idata);
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "", "");
        copiedFile = idata.getInstallPath()+File.separator+testFileName;
        MockResourceBuilder.copyResourceToInstall(testFilePath, copiedFile);
    }

    @Test
    public void testNonExistingFilesSkip() {
        boolean result = TextReplacer.run(handler, new String[]{
                "--file=doesntexist",
                "--regex=.*",
                "--text=testtext"});
        assertTrue(result);
    }

    @Test
    public void testReplaceFunctionality() throws Exception {
        boolean result = TextReplacer.run(handler, createTestArguments("--file="+copiedFile, "--replace=small", "--text=giant"));
        assertTrue(result);
        assertTrue(Files.lines(Paths.get(idata.getInstallPath(), testFileName)).anyMatch(line -> line.equals("this is a giant file")));
    }

    @Test
    public void testRemoveFunctionality() throws Exception {
        boolean result = TextReplacer.run(handler, createTestArguments("--file="+copiedFile, "--remove=intended", "--regex=.*quick test.*", "--text=designed"));
        assertTrue(result);
        assertTrue(Files.lines(Paths.get(idata.getInstallPath(), testFileName)).anyMatch(line -> line.equals("for the quick test")));
    }

    @Test
    public void testRegexFunctionality() throws Exception {
        boolean result = TextReplacer.run(handler, createTestArguments("--file="+copiedFile, "--regex=.*quick test.*", "--text=this will make us die"));
        assertTrue(result);
        assertTrue(Files.lines(Paths.get(idata.getInstallPath(), testFileName)).anyMatch(line -> line.equals("this will make us die")));
    }

    private String[] createTestArguments(String ... args){
        return args;
    }
}