package com.redhat.installer.layering.validator.container.eap;

import com.izforge.izpack.util.Debug;
import com.redhat.installer.layering.validator.container.VersionLoader;
import org.osgi.framework.Version;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EapVersionLoader implements VersionLoader {
    private static final String VERSION_REGEX = "\\b\\d\\.\\d\\.\\d[\\.\\w\\w\\d]*\\b";

    private Path installRoot;

    public EapVersionLoader(Path installRoot) {
        this.installRoot = installRoot;
    }

    @Override
    public Version load() {
        String foundEapVersion = "";
        Path eapVersionPath = Paths.get(installRoot.toString(), "version.txt");
        if (Files.exists(eapVersionPath)) {
            try (BufferedReader br = new BufferedReader(new FileReader(eapVersionPath.toString()))) {
                String versionLine = br.readLine();
                Pattern versionPattern = Pattern.compile(VERSION_REGEX);
                Matcher matcher = versionPattern.matcher(versionLine);
                if (matcher.find()) {
                    foundEapVersion = matcher.group();
                }
            } catch (IOException e) {
                Debug.log("IOException encountered when reading EAP version.txt");
            }
        }
        return Version.parseVersion(foundEapVersion);
    }
}
