/*
 * IzPack - Copyright 2001-2008 Julien Ponge, All Rights Reserved.
 * 
 * http://izpack.org/
 * http://izpack.codehaus.org/
 * 
 * Copyright 2004 Thorsten Kamann
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 *     
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.izforge.izpack.util;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

/**
 * A validator to check whether the field content is a port .
 *
 * @author thorque
 */
public class IsPortValidator implements Validator
{

    public Status validate(ProcessingClient client)
    {
        Status failureStatus = Status.ERROR;

        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get(WARNING_PARAM)))
            failureStatus = Status.WARNING;
        int port = 0;

        if ("".equals(client.getFieldContents(0)))
        {
            return failureStatus;
        }

        try
        {
            port = Integer.parseInt(client.getFieldContents(0));
            if (port > 0 && port < 65535)
            {
                return Status.OK;
            }
        }
        catch (Exception ex)
        {
            return failureStatus;
        }

        return failureStatus;
    }

}
