/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect;

import net.sf.jiapi.reflect.Instruction;

public class BranchInstruction
extends Instruction {
    private Instruction target;

    public BranchInstruction(byte[] bytes) {
        super(bytes);
    }

    public void setTarget(Instruction target) {
        this.target = target;
    }

    @Override
    public byte[] getBytes() {
        return super.getBytes();
    }

    public int getTargetOffset() {
        int offset;
        byte[] bytes = super.getBytes();
        if (bytes.length == 3) {
            offset = bytes[1] << 8;
            offset |= bytes[2] & 0xFF;
        } else {
            offset = bytes[1] << 24 | bytes[2] << 16 | bytes[3] << 8 | bytes[4];
        }
        return offset;
    }

    void setTargetOffset(int offset) {
        byte[] bytes = super.getBytes();
        if (bytes.length == 3) {
            bytes[1] = (byte)(offset >> 8);
            bytes[2] = (byte)(offset & 0xFF);
        } else {
            bytes[1] = (byte)(offset >> 24);
            bytes[2] = (byte)(offset >> 16);
            bytes[3] = (byte)(offset >> 8);
            bytes[4] = (byte)(offset & 0xFF);
        }
    }

    public Instruction getTarget() {
        return this.target;
    }

    public boolean isConditional() {
        switch (this.getOpcode()) {
            case -89: 
            case -88: 
            case -56: 
            case -55: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + ", offset=" + this.getTargetOffset() + " (" + this.getTarget() + ")";
    }
}

