/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log.jdk14logging;

import com.mchange.v2.log.LogUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.log.jdk14logging.Jdk14LoggingUtils;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class ForwardingLogger
extends Logger {
    MLogger forwardTo;

    public ForwardingLogger(MLogger forwardTo, String resourceBundleName) {
        super(forwardTo.getName(), resourceBundleName);
        this.forwardTo = forwardTo;
    }

    public void log(LogRecord lr) {
        String smn;
        Level lvl = lr.getLevel();
        MLevel mlvl = Jdk14LoggingUtils.mlevelFromLevel(lvl);
        String rbName = lr.getResourceBundleName();
        String msg = lr.getMessage();
        Object[] params = lr.getParameters();
        String finalMsg = LogUtils.formatMessage(rbName, msg, params);
        Throwable t = lr.getThrown();
        String scn = lr.getSourceClassName();
        boolean uses_srcloc = scn != null & (smn = lr.getSourceMethodName()) != null;
        if (!uses_srcloc) {
            this.forwardTo.log(mlvl, finalMsg, t);
        } else {
            this.forwardTo.logp(mlvl, scn, smn, finalMsg, t);
        }
    }
}

