/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.decode;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v3.decode.CannotDecodeException;
import com.mchange.v3.decode.Decoder;
import com.mchange.v3.decode.DecoderFinder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class DecodeUtils {
    public static final String DECODER_CLASS_DOT_KEY = ".decoderClass";
    public static final String DECODER_CLASS_NO_DOT_KEY = "decoderClass";
    private static final Object[] DECODER_CLASS_DOT_KEY_OBJ_ARRAY = new Object[]{".decoderClass"};
    private static final Object[] DECODER_CLASS_NO_DOT_KEY_OBJ_ARRAY = new Object[]{"decoderClass"};
    private static final MLogger logger = MLog.getLogger(DecodeUtils.class);
    private static final List<DecoderFinder> finders;
    private static final String[] finderClassNames;

    static final String findDecoderClassName(Object encoded) throws CannotDecodeException {
        for (DecoderFinder finder : finders) {
            String check = finder.decoderClassName(encoded);
            if (check == null) continue;
            return check;
        }
        throw new CannotDecodeException("Could not find a decoder class name for object: " + encoded);
    }

    public static Object decode(String decoderClassFqcn, Object encoded) throws CannotDecodeException {
        try {
            Class<?> clz = Class.forName(decoderClassFqcn);
            Decoder decoder = (Decoder)clz.newInstance();
            return decoder.decode(encoded);
        }
        catch (Exception e) {
            throw new CannotDecodeException("An exception occurred while attempting to decode " + encoded, e);
        }
    }

    public static Object decode(Object encoded) throws CannotDecodeException {
        return DecodeUtils.decode(DecodeUtils.findDecoderClassName(encoded), encoded);
    }

    private DecodeUtils() {
    }

    static {
        finderClassNames = new String[]{"com.mchange.sc.v1.decode.ScalaMapDecoderFinder"};
        LinkedList<DecoderFinder> tmp = new LinkedList<DecoderFinder>();
        tmp.add(new JavaMapDecoderFinder());
        int len = finderClassNames.length;
        for (int i = 0; i < len; ++i) {
            try {
                tmp.add((DecoderFinder)Class.forName(finderClassNames[i]).newInstance());
                continue;
            }
            catch (Exception e) {
                if (!logger.isLoggable(MLevel.INFO)) continue;
                logger.log(MLevel.INFO, "Could not load DecoderFinder '" + finderClassNames[i] + "'", e);
            }
        }
        finders = Collections.unmodifiableList(tmp);
    }

    static class JavaMapDecoderFinder
    implements DecoderFinder {
        JavaMapDecoderFinder() {
        }

        public String decoderClassName(Object encoded) throws CannotDecodeException {
            if (encoded instanceof Map) {
                String className = null;
                Map map = (Map)encoded;
                className = (String)map.get(DecodeUtils.DECODER_CLASS_DOT_KEY);
                if (className == null) {
                    className = (String)map.get(DecodeUtils.DECODER_CLASS_NO_DOT_KEY);
                }
                if (className == null) {
                    throw new CannotDecodeException("Could not find the decoder class for java.util.Map: " + encoded);
                }
                return className;
            }
            return null;
        }
    }
}

