package com.redhat.installer.asconfiguration.ascontroller;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandLineException;

/**
 * Used for launching the server in embedded mode.
 * Created by Tom on 10/5/2015.
 */
public class EmbeddedServerManager {
    static final String EMBED = "embed-server --jboss-home=%s --server-config=%s";
    static AutomatedInstallData idata;

    public static boolean run(AbstractUIProcessHandler handler, String[]args)  {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        idata = AutomatedInstallData.getInstance();
        String descriptor = args[0];
        CommandContext cc;
        try {
            cc = CommandContextFactory.getInstance().newCommandContext();
            cc.handle(String.format(EMBED, idata.getInstallPath(), descriptor));
        } catch(CommandLineException e){
            ProcessPanelHelper.printToPanel(handler, e.getMessage(), true);
            return false;
        }
        idata.setAttribute("embedded.server", cc);
        return true;
    }
}
