package com.redhat.installer.installation.action.defaults;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.installation.action.defaults.SetDefaults;

import java.util.HashMap;
import java.util.Map;

public class SetRhpamDefaults extends SetDefaults {

    protected static final String ROLE_ADMINISTRATOR = "role.administrator";
    protected static final String ROLE_KIESERVER = "role.kieserver";
    protected static final String ROLE_RESTALL = "role.restall";
    protected static final String ROLE_ANALYST = "role.analyst";
    protected static final String ROLE_DEVELOPER = "role.developer";
    protected static final String ROLE_USER = "role.user";
    protected static final String ROLE_MANAGER = "role.manager";
    protected static final String ROLE_PROCESSADMIN = "role.processadmin";

    @Override
    public Map<String, String> getDefaultMap() {
        Map<String, String> defaults = new HashMap<>();
        defaults.putAll(roles());
        defaults.putAll(kieController());
        return defaults;
    }

    private Map<String, String> roles() {
        AutomatedInstallData adata = AutomatedInstallData.getInstance();

        String isBusinessCentralString = Boolean.toString(adata.getRules().isConditionTrue("izpack.selected.rhpam.eap"));

        return new HashMap<String, String>() {{
            put(ROLE_ADMINISTRATOR, isBusinessCentralString);
            put(ROLE_KIESERVER, "true");
            put(ROLE_RESTALL, isBusinessCentralString);
            put(ROLE_ANALYST, "false");
            put(ROLE_DEVELOPER, "false");
            put(ROLE_USER, "false");
            put(ROLE_MANAGER, "false");
            put(ROLE_PROCESSADMIN, "false");
        }};
    }

    private Map<String, String> kieController() {
        AutomatedInstallData adata = AutomatedInstallData.getInstance();

        boolean onlyProcessServerInstall = adata.getRules().isConditionTrue("only.kie.server.install");

        String urlVariable = onlyProcessServerInstall ?
                "org.kie.server.kie-server.controller" :
                "org.kie.server.business-central.controller";

        return new HashMap<String, String>() {{
            put("org.kie.server.controller", adata.getVariable(urlVariable));
        }};
    }

}
