<?xml version="1.0" encoding="UTF-8"?>
<!--
~ JBoss, Home of Professional Open Source.
~ Copyright 2011, Red Hat, Inc., and individual contributors
~ as indicated by the @author tags. See the copyright.txt file in the
~ distribution for a full listing of individual contributors.
~
~ This is free software; you can redistribute it and/or modify it
~ under the terms of the GNU Lesser General Public License as
~ published by the Free Software Foundation; either version 2.1 of
~ the License, or (at your option) any later version.
~
~ This software is distributed in the hope that it will be useful,
~ but WITHOUT ANY WARRANTY; without even the implied warranty of
~ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
~ Lesser General Public License for more details.
~
~ You should have received a copy of the GNU Lesser General Public
~ License along with this software; if not, write to the Free
~ Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
~ 02110-1301 USA, or see the FSF site: http://www.fsf.org.
-->
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:fn="http://www.w3.org/2005/xpath-functions"
                xmlns:xdt="http://www.w3.org/2005/xpath-datatypes"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:jb="urn:jboss:domain:16.0"
                exclude-result-prefixes="xs xsl xsi fn xdt jb cache-container">

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

  <xsl:template match="*[@name='ManagementRealm']">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" />
    </xsl:copy>
    <xsl:if test="ancestor::node()[name(.)='management'] ">
      <xsl:text disable-output-escaping="yes">
      <![CDATA[
        <security-realm name="ApplicationRealm">
            <server-identities>
                <ssl>
                    <keystore path="application.keystore" relative-to="jboss.server.config.dir" keystore-password="password" alias="server" key-password="password" generate-self-signed-certificate-host="localhost"/>
                </ssl>
            </server-identities>
       </security-realm>
       ]]>
      </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="*[@default-realm='ApplicationRealm']">
    <xsl:text disable-output-escaping="yes">
      <![CDATA[
       <security-domain name="ApplicationDomain" default-realm="ApplicationRealm" permission-mapper="default-permission-mapper">
          <realm name="ApplicationRealm" role-decoder="from-roles-attribute"/>
          <realm name="local"/>
       </security-domain>
       ]]>
    </xsl:text>
  </xsl:template>

  <xsl:template match="*[@name='ApplicationRealm']">
    <xsl:if test="ancestor::node()[name(.)='subsystem'] ">
      <xsl:text disable-output-escaping="yes">
        <![CDATA[
         <filesystem-realm name="ApplicationRealm">
             <file path="kie-fs-realm-users" relative-to="jboss.server.config.dir"/>
         </filesystem-realm>
         ]]>
      </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="node()[name(.)='servlet-container']">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" />
    </xsl:copy>
    <xsl:text disable-output-escaping="yes">
      <![CDATA[
        <application-security-domains>
            <application-security-domain name="other" security-domain="ApplicationDomain"/>
        </application-security-domains>
       ]]>
    </xsl:text>
  </xsl:template>

  <xsl:template match="node()[name(.)='default-security-domain']">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" />
    </xsl:copy>
    <xsl:text disable-output-escaping="yes">
      <![CDATA[
        <application-security-domains>
            <application-security-domain name="other" security-domain="ApplicationDomain"/>
        </application-security-domains>
       ]]>
    </xsl:text>
  </xsl:template>

  <xsl:template match="node()[name(.)='simple-role-decoder']">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" />
    </xsl:copy>
    <xsl:text disable-output-escaping="yes">
      <![CDATA[
        <simple-role-decoder name="from-roles-attribute" attribute="role"/>
       ]]>
    </xsl:text>
  </xsl:template>

  <xsl:template match="node()[name(.)='http-authentication-factory']">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()" />
    </xsl:copy>
    <xsl:text disable-output-escaping="yes">
      <![CDATA[
        <http-authentication-factory name="application-http-authentication" security-domain="ApplicationDomain" http-server-mechanism-factory="global">
            <mechanism-configuration>
                <mechanism mechanism-name="BASIC">
                    <mechanism-realm realm-name="ApplicationRealm"/>
                </mechanism>
                <mechanism mechanism-name="FORM"/>
            </mechanism-configuration>
        </http-authentication-factory>
       ]]>
    </xsl:text>
  </xsl:template>

  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
