/*
 * Copyright 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.optaplanner.workbench.screens.domaineditor.client.resources.i18n;

import org.jboss.errai.ui.shared.api.annotations.TranslationKey;

/**
 * Domain Editor i18n constants.
 */
public interface DomainEditorConstants {

    @TranslationKey(defaultValue = "")
    String PlannerDomainScreenName = "PlannerDomainScreen.name";

    @TranslationKey(defaultValue = "")
    String PlannerDataObjectEditorComparatorDefinitionProcessingFailed = "PlannerDataObjectEditor.ComparatorDefinitionProcessingFailed";

    @TranslationKey(defaultValue = "")
    String PlannerDataObjectEditorViewImplPlanningSolutionHelpIconContent = "PlannerDataObjectEditorViewImpl.PlanningSolutionHelpIconContent";

    @TranslationKey(defaultValue = "")
    String PlannerCheckTranslatorMultiplePlanningSolutionsToBeCreated = "PlannerCheckTranslator.MultiplePlanningSolutionsToBeCreated";

    @TranslationKey(defaultValue = "")
    String PlannerCheckTranslatorScoreHolderGlobalToBeDeleted = "PlannerCheckTranslator.ScoreHolderGlobalToBeDeleted";

    @TranslationKey(defaultValue = "")
    String PlannerCheckTranslatorScoreHolderGlobalToBeChanged = "PlannerCheckTranslator.ScoreHolderGlobalToBeChanged";

    @TranslationKey(defaultValue = "")
    String PlannerCheckTranslatorScoreHolderGlobalTypeNotRecognized = "PlannerCheckTranslator.ScoreHolderGlobalTypeNotRecognized";

    @TranslationKey(defaultValue = "")
    String PlannerCheckTranslatorScoreHolderGlobalFileToBeRemovedMessage = "PlannerCheckTranslator.ScoreHolderGlobalFileToBeRemovedMessage";

    @TranslationKey(defaultValue = "")
    String PlannerCheckTranslatorScoreHolderGlobalToBeDefinedManuallyMessage = "PlannerCheckTranslator.ScoreHolderGlobalToBeDefinedManuallyMessage";

    @TranslationKey(defaultValue = "")
    String PlannerCheckTranslatorPlanningScoreToBeDeletedMessage = "PlannerCheckTranslator.PlanningScoreToBeDeletedMessage";

    @TranslationKey(defaultValue = "")
    String PlannerFieldMetadataProvider_PlanningScore = "PlannerFieldMetadataProvider.PlanningScore";

    @TranslationKey(defaultValue = "")
    String PlannerFieldMetadataProvider_PlanningVariable = "PlannerFieldMetadataProvider.PlanningVariable";

    @TranslationKey(defaultValue = "")
    String PlannerFieldMetadataProvider_ValueRangeProvider = "PlannerFieldMetadataProvider.ValueRangeProvider";
}