package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.installation.util.TomcatUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class TomcatAddRoles {
    private static AbstractUIProcessHandler mHandler;
    private static AutomatedInstallData idata;
    private static List<String> kieRoles;

    static {
        // should these be the same as for EAP?
        kieRoles = new ArrayList<>();
        kieRoles.add("admin");
        kieRoles.add("kie-server");
        kieRoles.add("rest-all");
        kieRoles.add("analyst");
        kieRoles.add("developer");
        kieRoles.add("user");
        kieRoles.add("manager");
        kieRoles.add("process-admin");
    }

    /**
     * Adds the user defined in the installation to tomcat-users.xml
     *
     * @param handler supplied by internal izpack library. Used to output to panel / console
     * @param args    User information. args[0]: username args[1]: password args[2]: role1,role2 etc
     * @return true upon successful addition of roles and user to the existing tomcat-users.xml
     */
    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        idata = AutomatedInstallData.getInstance();
        mHandler = handler;
        // roles will be standard rhpam roles
        return addRolesToTomcatUsersFile();
    }

    private static boolean addRolesToTomcatUsersFile() {
        try {
            Path tomcatUsersPath = Paths.get(idata.getInstallPath() + "/conf/tomcat-users.xml");
            Document xml = TomcatUtils.getXmlDocument(tomcatUsersPath);
            xml.getDocumentElement().appendChild(xml.createComment(idata.langpack.getString("tomcat.installer.comment")));
            addKIERoles(xml);
            TomcatUtils.writeXmlDocumentToFile(xml, tomcatUsersPath);
        } catch (ParserConfigurationException | IOException | SAXException | TransformerException | XPathExpressionException e) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.userfile.addroles.failed"), true);
            ProcessPanelHelper.printExceptionToLog(e.getStackTrace());
            return false;
        }
        ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.userfile.addroles.success"), false);
        return true;
    }

    /**
     * Adds all roles that are in the kieRoles list into the existingElements Jsoup element list
     *
     * @param xml input Jsoup Elements object. Typically a parsed tomcat-users.xml
     */
    private static void addKIERoles(Document xml) {
        for (String rolename : kieRoles) {
            Element role = xml.createElement("role");
            role.setAttribute("rolename", rolename);
            xml.getDocumentElement().appendChild(role);
        }
    }
}
