package org.jboss.brmsbpmsuite.patching.client;

import com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import java.io.File;
import java.util.Collection;

@RunWith(Parameterized.class)
public class InvalidRootsDistributionCheckerFactoryTest extends BaseClientPatcherTest {

    private static File validRootsBasedir = getCPResourceAsFile("/distribution-checker-test/invalid-roots");

    @Parameterized.Parameters(name = "{index}: {0}-{1}, root={2}")
    public static Collection<Object[]> data() {
        return Lists.newArrayList(new Object[][]{
                        // individual WARs
                        {DistributionType.RHPAM_EAP7X_BC, TargetProduct.RHPAM, "unknown-content"}
                }
        );
    }

    @Parameterized.Parameter(0)
    public DistributionType distributionType;

    @Parameterized.Parameter(1)
    public TargetProduct targetProduct;

    @Parameterized.Parameter(2)
    public String distributionRootPath;

    @Test
    public void shouldReportInValidDistributionRoot() {
        DistributionChecker checker = DistributionCheckerFactory.create(distributionType, targetProduct);
        Assert.assertFalse("Distribution root should be marked as invalid!",
                checker.check(new File(validRootsBasedir, distributionRootPath)));
    }

}
