package com.redhat.installer.installation.validator;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by jjavier on 24/11/16.
 */
public class RolesValidator implements Validator {

    private static final String DEFAULT_ROLE_PARAM = "defaults";

    @Override
    public Status validate(ProcessingClient client) {
        String fieldValue = client.getFieldContents(0);

        if (fieldValue.isEmpty()) return Status.OK;

        //Check for duplicates in user input
        String[] userInputRoles = fieldValue.split(",");
        Set<String> userInputSet = new HashSet<String>(Arrays.asList(userInputRoles));

        if (userInputSet.size() != userInputRoles.length) {
            return Status.ERROR;
        }

        //Check for duplicates against default roles
        if (client.hasParams()) {
            Map<String, String> paramMap = client.getValidatorParams();
            String defaultRoleString = paramMap.get(DEFAULT_ROLE_PARAM);

            String[] defaultRoles = defaultRoleString.split(",");

            for (String userInputRole : userInputSet) {
                for (String defaultRole : defaultRoles) {
                    if (userInputRole.equals(defaultRole)) {
                        return Status.ERROR;
                    }
                }
            }
        }

        return Status.OK;

    }

}
