/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.title;

import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.BaseHeaderPainter;
import org.jvnet.substance.title.Glass3DTitlePainter;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class MatteHeaderPainter
extends BaseHeaderPainter {
    public static final String DISPLAY_NAME = "Matte";
    private SubstanceTitlePainter secondaryPainter = new Glass3DTitlePainter();
    private boolean isPaintingToolbars;
    private boolean isPaintingToolbarDropShadows;

    public MatteHeaderPainter() {
        this(true, true);
    }

    public MatteHeaderPainter(boolean isPaintingToolbars, boolean isPaintingGeneralDecorationAreas) {
        super(isPaintingToolbars, isPaintingGeneralDecorationAreas);
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public void paintTitleBackground(Graphics2D graphics, Component comp, int width, int height, int leftTitleX, int rightTitleX, SubstanceTheme theme, float borderAlpha) {
        ColorScheme scheme = theme.getColorScheme();
        Graphics2D temp = (Graphics2D)graphics.create();
        this.fill(temp, scheme, 0, 0, 0, width, height);
        temp.dispose();
    }

    public void paintExtraBackground(Graphics2D graphics, Container parent, Component comp, int width, int height, SubstanceTheme theme, boolean hasDarkBorder) {
        JRootPane rootPane = SwingUtilities.getRootPane(parent);
        int dx = 0;
        int dy = 0;
        JComponent titlePane = null;
        if (rootPane != null && (titlePane = SubstanceCoreUtilities.getTitlePane(rootPane)) != null) {
            if (comp.isShowing() && titlePane.isShowing()) {
                dx += comp.getLocationOnScreen().x - titlePane.getLocationOnScreen().x;
                dy += comp.getLocationOnScreen().y - titlePane.getLocationOnScreen().y;
            } else {
                Component c;
                dx = 0;
                dy = 0;
                for (c = comp; c != rootPane; c = c.getParent()) {
                    dx += c.getX();
                    dy += c.getY();
                }
                for (c = titlePane; c != rootPane; c = c.getParent()) {
                    dx -= c.getX();
                    dy -= c.getY();
                }
            }
        }
        ColorScheme scheme = theme.getColorScheme();
        Graphics2D temp = (Graphics2D)graphics.create();
        this.fill(temp, scheme, dy, 0, 0, width, height);
        temp.dispose();
    }

    protected void fill(Graphics2D graphics, ColorScheme scheme, int offsetY, int x, int y, int width, int height) {
        int bandHeight = 20;
        int startY = y + offsetY;
        int endY = y + offsetY + height;
        int currStart = 0;
        int currEnd = bandHeight;
        if (currEnd >= startY) {
            graphics.setPaint(new GradientPaint(x, currStart - offsetY, scheme.getUltraLightColor(), x, currEnd - offsetY, scheme.getExtraLightColor()));
            graphics.fillRect(x, currStart - offsetY, width, bandHeight);
        }
        currEnd += bandHeight;
        if ((currStart += bandHeight) > endY) {
            return;
        }
        if (currEnd >= startY) {
            graphics.setPaint(new GradientPaint(x, currStart - offsetY, scheme.getExtraLightColor(), x, currEnd - offsetY, scheme.getLightColor()));
            graphics.fillRect(x, currStart - offsetY, width, bandHeight);
        }
        currEnd += bandHeight;
        if ((currStart += bandHeight) > endY) {
            return;
        }
        if (currEnd >= startY) {
            graphics.setPaint(new GradientPaint(x, currStart - offsetY, scheme.getLightColor(), x, currEnd - offsetY, scheme.getMidColor()));
            graphics.fillRect(x, currStart - offsetY, width, bandHeight);
        }
        currEnd += bandHeight;
        if ((currStart += bandHeight) > endY) {
            return;
        }
        if (currEnd >= startY) {
            graphics.setPaint(new GradientPaint(x, currStart - offsetY, scheme.getMidColor(), x, currEnd - offsetY, scheme.getDarkColor()));
            graphics.fillRect(x, currStart - offsetY, width, bandHeight);
        }
        currEnd += bandHeight;
        if ((currStart += bandHeight) > endY) {
            return;
        }
        if (currEnd >= startY) {
            graphics.setPaint(new GradientPaint(x, currStart - offsetY, scheme.getDarkColor(), x, currEnd - offsetY, scheme.getUltraDarkColor()));
            graphics.fillRect(x, currStart - offsetY, width, bandHeight);
        }
        currEnd += bandHeight;
        if ((currStart += bandHeight) > endY) {
            return;
        }
        graphics.setColor(scheme.getUltraDarkColor());
        graphics.fillRect(x, currStart - offsetY, width, endY - currStart + offsetY);
    }

    public SubstanceTitlePainter getSecondaryPainter() {
        return this.secondaryPainter;
    }
}

