/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.facelets.FaceletCacheFactory;
import javax.faces.view.facelets.TagHandlerDelegateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String EXCEPTION_HANDLER_FACTORY = "javax.faces.context.ExceptionHandlerFactory";
    public static final String EXTERNAL_CONTEXT_FACTORY = "javax.faces.context.ExternalContextFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String FACELET_CACHE_FACTORY = "javax.faces.view.facelets.FaceletCacheFactory";
    public static final String PARTIAL_VIEW_CONTEXT_FACTORY = "javax.faces.context.PartialViewContextFactory";
    public static final String VISIT_CONTEXT_FACTORY = "javax.faces.component.visit.VisitContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    public static final String VIEW_DECLARATION_LANGUAGE_FACTORY = "javax.faces.view.ViewDeclarationLanguageFactory";
    public static final String TAG_HANDLER_DELEGATE_FACTORY = "javax.faces.view.facelets.TagHandlerDelegateFactory";
    private static final FactoryManagerCache FACTORIES_CACHE = new FactoryManagerCache(null);
    private static final String[] FACTORY_NAMES = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.component.visit.VisitContextFactory", "javax.faces.context.ExceptionHandlerFactory", "javax.faces.context.ExternalContextFactory", "javax.faces.context.FacesContextFactory", "javax.faces.context.PartialViewContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory", "javax.faces.view.ViewDeclarationLanguageFactory", "javax.faces.view.facelets.FaceletCacheFactory", "javax.faces.view.facelets.TagHandlerDelegateFactory"};
    private static Map<String, Class> factoryClasses;
    private static final Logger LOGGER;

    FactoryFinder() {
    }

    public static Object getFactory(String factoryName) throws FacesException {
        FactoryFinder.validateFactoryName((String)factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        FactoryManager manager = FactoryManagerCache.access$100((FactoryManagerCache)FACTORIES_CACHE, (ClassLoader)classLoader);
        return manager.getFactory(classLoader, factoryName);
    }

    public static void setFactory(String factoryName, String implName) {
        FactoryFinder.validateFactoryName((String)factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        FactoryManager manager = FactoryManagerCache.access$100((FactoryManagerCache)FACTORIES_CACHE, (ClassLoader)classLoader);
        manager.addFactory(factoryName, implName);
    }

    public static void releaseFactories() throws FacesException {
        ClassLoader cl = FactoryFinder.getClassLoader();
        FACTORIES_CACHE.removeApplicationFactoryManager(cl);
    }

    private static ClassLoader getClassLoader() throws FacesException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            throw new FacesException("getContextClassLoader");
        }
        return cl;
    }

    private static Object getImplementationInstance(ClassLoader classLoader, String factoryName, List implementations) throws FacesException {
        List fromServices;
        String curImplClass;
        int len;
        Object result = null;
        if (null != implementations && (1 < (len = implementations.size()) || 1 == len)) {
            curImplClass = (String)implementations.remove(len - 1);
            result = FactoryFinder.getImplGivenPreviousImpl((ClassLoader)classLoader, (String)factoryName, (String)curImplClass, null);
        }
        if ((fromServices = FactoryFinder.getImplNameFromServices((ClassLoader)classLoader, (String)factoryName)) != null) {
            for (String name : fromServices) {
                result = FactoryFinder.getImplGivenPreviousImpl((ClassLoader)classLoader, (String)factoryName, (String)name, (Object)result);
            }
        }
        if (null != implementations) {
            for (len = implementations.size() - 1; 0 <= len; --len) {
                curImplClass = (String)implementations.remove(len);
                result = FactoryFinder.getImplGivenPreviousImpl((ClassLoader)classLoader, (String)factoryName, (String)curImplClass, (Object)result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getImplNameFromServices(ClassLoader classLoader, String factoryName) {
        ArrayList<String> result;
        block12: {
            result = null;
            String resourceName = "META-INF/services/" + factoryName;
            BufferedReader reader = null;
            try {
                Enumeration<URL> e = classLoader.getResources(resourceName);
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    InputStream stream = conn.getInputStream();
                    if (stream == null) continue;
                    try {
                        reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                        if (result == null) {
                            result = new ArrayList<String>(3);
                        }
                        result.add(reader.readLine());
                    }
                    catch (UnsupportedEncodingException uee) {
                        reader = new BufferedReader(new InputStreamReader(stream));
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                            reader = null;
                        }
                        if (stream == null) continue;
                        stream.close();
                        stream = null;
                    }
                }
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
            catch (SecurityException e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block12;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        return result;
    }

    private static Object getImplGivenPreviousImpl(ClassLoader classLoader, String factoryName, String implName, Object previousImpl) {
        Class<?> clazz;
        Class factoryClass = null;
        Object[] newInstanceArgs = new Object[1];
        Object result = null;
        if (null != previousImpl && null != (factoryClass = FactoryFinder.getFactoryClass((String)factoryName))) {
            try {
                clazz = Class.forName(implName, false, classLoader);
                Class[] getCtorArg = new Class[]{factoryClass};
                Constructor<?> ctor = clazz.getConstructor(getCtorArg);
                newInstanceArgs[0] = previousImpl;
                result = ctor.newInstance(newInstanceArgs);
            }
            catch (NoSuchMethodException nsme) {
                factoryClass = null;
            }
            catch (Exception e) {
                throw new FacesException(implName, (Throwable)e);
            }
        }
        if (null == previousImpl || null == factoryClass) {
            try {
                clazz = Class.forName(implName, false, classLoader);
                result = clazz.newInstance();
            }
            catch (Exception e) {
                throw new FacesException(implName, (Throwable)e);
            }
        }
        return result;
    }

    private static Class getFactoryClass(String factoryClassName) {
        return (Class)factoryClasses.get(factoryClassName);
    }

    private static void validateFactoryName(String factoryName) {
        if (factoryName == null) {
            throw new NullPointerException();
        }
        if (Arrays.binarySearch(FACTORY_NAMES, factoryName) < 0) {
            throw new IllegalArgumentException(factoryName);
        }
    }

    private static void reInitializeFactoryManager() {
        FACTORIES_CACHE.resetSpecialInitializationCaseFlags();
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ String[] access$300() {
        return FACTORY_NAMES;
    }

    static /* synthetic */ Object access$400(ClassLoader x0, String x1, List x2) throws FacesException {
        return FactoryFinder.getImplementationInstance((ClassLoader)x0, (String)x1, (List)x2);
    }

    static /* synthetic */ FactoryManagerCache access$500() {
        return FACTORIES_CACHE;
    }

    static {
        Arrays.sort(FACTORY_NAMES);
        factoryClasses = new HashMap(FACTORY_NAMES.length);
        factoryClasses.put("javax.faces.application.ApplicationFactory", ApplicationFactory.class);
        factoryClasses.put("javax.faces.context.ExceptionHandlerFactory", ExceptionHandlerFactory.class);
        factoryClasses.put("javax.faces.context.ExternalContextFactory", ExternalContextFactory.class);
        factoryClasses.put("javax.faces.context.FacesContextFactory", FacesContextFactory.class);
        factoryClasses.put("javax.faces.view.facelets.FaceletCacheFactory", FaceletCacheFactory.class);
        factoryClasses.put("javax.faces.component.visit.VisitContextFactory", VisitContextFactory.class);
        factoryClasses.put("javax.faces.lifecycle.LifecycleFactory", LifecycleFactory.class);
        factoryClasses.put("javax.faces.context.PartialViewContextFactory", PartialViewContextFactory.class);
        factoryClasses.put("javax.faces.render.RenderKitFactory", RenderKitFactory.class);
        factoryClasses.put("javax.faces.view.ViewDeclarationLanguageFactory", ViewDeclarationLanguageFactory.class);
        factoryClasses.put("javax.faces.view.facelets.TagHandlerDelegateFactory", TagHandlerDelegateFactory.class);
        LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");
    }
}

