package org.jboss.brmsbpmsuite.patching.client;

import com.google.common.collect.Lists;
import org.junit.Test;

import java.io.File;
import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

public class PatcherFactoryTest extends BaseClientPatcherTest {

    @Test
    public void shouldCreateCorrectPatcher() {
        File distributionRoot = getCPResourceAsFile("/patcher-factory-test/brms-engine-distro");
        File patchBaseDir = getCPResourceAsFile("/patcher-factory-test/patch-dir");
        ClientPatcherConfig config = clientPatcherConfig(distributionRoot, patchBaseDir);
        DistributionPatcher patcher = PatcherFactory.newDistributionPatcher(config);
        assertTrue("Incorrect patcher type!", patcher instanceof GeneralDistributionPatcher);
    }

    @Test
    public void shouldRecognizeBrmsEngineDistro() {
        File distributionRoot = getCPResourceAsFile("/patcher-factory-test/brms-engine-distro");
        File patchBaseDir = getCPResourceAsFile("/patcher-factory-test/patch-dir");
        ClientPatcherConfig config = clientPatcherConfig(distributionRoot, patchBaseDir);
        DirectoryPatcher dirPatcher = PatcherFactory.newDirectoryPatcher(config.getDistributionRoot(),
                config.getPatchBasedir(), config.getDistributionType().getRelativePath());
        assertEquals("Incorrect distribution root!", distributionRoot, dirPatcher.rootDir);

        List<String> expectedRemoveList = Lists.newArrayList(
                "drools-compiler-6.2.0.Final-redhat-3.jar",
                "drools-core-6.2.0.Final-redhat-3.jar",
                "lib/ecj-4.3.1.redhat-1.jar",
                "lib/maven-core-3.2.2.jar",
                "SecurityPolicy/kie.policy"
        );
        assertEqualsIgnoreOrder("Incorrect remove list!", expectedRemoveList, dirPatcher.removeList);

        List<String> expectedBlackList = Lists.newArrayList("SecurityPolicy/kie.policy", "SecurityPolicy/security.policy");
        assertEqualsIgnoreOrder("Incorrect black list!", expectedBlackList, dirPatcher.blackList);

        File newContentDir = new File(patchBaseDir, "updates/new-content");
        List<PatchEntry> expectedPatchEntries = Lists.newArrayList(
                newPatchEntry("drools-compiler-6.2.0.Final-redhat-4.jar", newContentDir),
                newPatchEntry("drools-core-6.2.0.Final-redhat-4.jar", newContentDir),
                newPatchEntry("lib/ecj-4.3.1.redhat-2.jar", newContentDir),
                newPatchEntry("lib/maven-core-3.2.3.jar", newContentDir),
                newPatchEntry("SecurityPolicy/kie.policy", newContentDir)
        );
        assertEqualsIgnoreOrder("Incorrect patch entries!", expectedPatchEntries, dirPatcher.patchEntries);
    }

    private ClientPatcherConfig clientPatcherConfig(File distributionRoot, File patchBaseDir) {
        ClientPatcherConfig config = new ClientPatcherConfig();
        config.setDistributionType(DistributionType.RHPAM_EAP7X_BC);
        config.setProduct(TargetProduct.RHPAM);
        config.setDistributionRoot(distributionRoot);
        config.setPatchBasedir(patchBaseDir);
        return config;
    }

    private PatchEntry newPatchEntry(String relPath, File sharedNewContentDir) {
        return new PatchEntry(relPath, new File(sharedNewContentDir, new File(relPath).getName() +  ".md5sum"));
    }

}
