// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerResizeLibpodParams creates a new ContainerResizeLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerResizeLibpodParams() *ContainerResizeLibpodParams {
	return &ContainerResizeLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerResizeLibpodParamsWithTimeout creates a new ContainerResizeLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerResizeLibpodParamsWithTimeout(timeout time.Duration) *ContainerResizeLibpodParams {
	return &ContainerResizeLibpodParams{
		timeout: timeout,
	}
}

// NewContainerResizeLibpodParamsWithContext creates a new ContainerResizeLibpodParams object
// with the ability to set a context for a request.
func NewContainerResizeLibpodParamsWithContext(ctx context.Context) *ContainerResizeLibpodParams {
	return &ContainerResizeLibpodParams{
		Context: ctx,
	}
}

// NewContainerResizeLibpodParamsWithHTTPClient creates a new ContainerResizeLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerResizeLibpodParamsWithHTTPClient(client *http.Client) *ContainerResizeLibpodParams {
	return &ContainerResizeLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerResizeLibpodParams contains all the parameters to send to the API endpoint

	for the container resize libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerResizeLibpodParams struct {

	/* H.

	   Height to set for the terminal, in characters
	*/
	H *int64

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* W.

	   Width to set for the terminal, in characters
	*/
	W *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container resize libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerResizeLibpodParams) WithDefaults() *ContainerResizeLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container resize libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerResizeLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the container resize libpod params
func (o *ContainerResizeLibpodParams) WithTimeout(timeout time.Duration) *ContainerResizeLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container resize libpod params
func (o *ContainerResizeLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container resize libpod params
func (o *ContainerResizeLibpodParams) WithContext(ctx context.Context) *ContainerResizeLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container resize libpod params
func (o *ContainerResizeLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container resize libpod params
func (o *ContainerResizeLibpodParams) WithHTTPClient(client *http.Client) *ContainerResizeLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container resize libpod params
func (o *ContainerResizeLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithH adds the h to the container resize libpod params
func (o *ContainerResizeLibpodParams) WithH(h *int64) *ContainerResizeLibpodParams {
	o.SetH(h)
	return o
}

// SetH adds the h to the container resize libpod params
func (o *ContainerResizeLibpodParams) SetH(h *int64) {
	o.H = h
}

// WithName adds the name to the container resize libpod params
func (o *ContainerResizeLibpodParams) WithName(name string) *ContainerResizeLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container resize libpod params
func (o *ContainerResizeLibpodParams) SetName(name string) {
	o.Name = name
}

// WithW adds the w to the container resize libpod params
func (o *ContainerResizeLibpodParams) WithW(w *int64) *ContainerResizeLibpodParams {
	o.SetW(w)
	return o
}

// SetW adds the w to the container resize libpod params
func (o *ContainerResizeLibpodParams) SetW(w *int64) {
	o.W = w
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerResizeLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.H != nil {

		// query param h
		var qrH int64

		if o.H != nil {
			qrH = *o.H
		}
		qH := swag.FormatInt64(qrH)
		if qH != "" {

			if err := r.SetQueryParam("h", qH); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.W != nil {

		// query param w
		var qrW int64

		if o.W != nil {
			qrW = *o.W
		}
		qW := swag.FormatInt64(qrW)
		if qW != "" {

			if err := r.SetQueryParam("w", qW); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
