// Code generated by go-swagger; DO NOT EDIT.

package secrets

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SecretCreateLibpodReader is a Reader for the SecretCreateLibpod structure.
type SecretCreateLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecretCreateLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewSecretCreateLibpodCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewSecretCreateLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSecretCreateLibpodCreated creates a SecretCreateLibpodCreated with default headers values
func NewSecretCreateLibpodCreated() *SecretCreateLibpodCreated {
	return &SecretCreateLibpodCreated{}
}

/*
SecretCreateLibpodCreated describes a response with status code 201, with default header values.

Secret create response
*/
type SecretCreateLibpodCreated struct {
	Payload *SecretCreateLibpodCreatedBody
}

// IsSuccess returns true when this secret create libpod created response has a 2xx status code
func (o *SecretCreateLibpodCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this secret create libpod created response has a 3xx status code
func (o *SecretCreateLibpodCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this secret create libpod created response has a 4xx status code
func (o *SecretCreateLibpodCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this secret create libpod created response has a 5xx status code
func (o *SecretCreateLibpodCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this secret create libpod created response a status code equal to that given
func (o *SecretCreateLibpodCreated) IsCode(code int) bool {
	return code == 201
}

func (o *SecretCreateLibpodCreated) Error() string {
	return fmt.Sprintf("[POST /libpod/secrets/create][%d] secretCreateLibpodCreated  %+v", 201, o.Payload)
}

func (o *SecretCreateLibpodCreated) String() string {
	return fmt.Sprintf("[POST /libpod/secrets/create][%d] secretCreateLibpodCreated  %+v", 201, o.Payload)
}

func (o *SecretCreateLibpodCreated) GetPayload() *SecretCreateLibpodCreatedBody {
	return o.Payload
}

func (o *SecretCreateLibpodCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SecretCreateLibpodCreatedBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecretCreateLibpodInternalServerError creates a SecretCreateLibpodInternalServerError with default headers values
func NewSecretCreateLibpodInternalServerError() *SecretCreateLibpodInternalServerError {
	return &SecretCreateLibpodInternalServerError{}
}

/*
SecretCreateLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type SecretCreateLibpodInternalServerError struct {
	Payload *SecretCreateLibpodInternalServerErrorBody
}

// IsSuccess returns true when this secret create libpod internal server error response has a 2xx status code
func (o *SecretCreateLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this secret create libpod internal server error response has a 3xx status code
func (o *SecretCreateLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this secret create libpod internal server error response has a 4xx status code
func (o *SecretCreateLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this secret create libpod internal server error response has a 5xx status code
func (o *SecretCreateLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this secret create libpod internal server error response a status code equal to that given
func (o *SecretCreateLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *SecretCreateLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/secrets/create][%d] secretCreateLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *SecretCreateLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/secrets/create][%d] secretCreateLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *SecretCreateLibpodInternalServerError) GetPayload() *SecretCreateLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *SecretCreateLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SecretCreateLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecretCreateLibpodCreatedBody secret create libpod created body
swagger:model SecretCreateLibpodCreatedBody
*/
type SecretCreateLibpodCreatedBody struct {

	// ID
	ID string `json:"ID,omitempty"`
}

// Validate validates this secret create libpod created body
func (o *SecretCreateLibpodCreatedBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this secret create libpod created body based on context it is used
func (o *SecretCreateLibpodCreatedBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SecretCreateLibpodCreatedBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecretCreateLibpodCreatedBody) UnmarshalBinary(b []byte) error {
	var res SecretCreateLibpodCreatedBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecretCreateLibpodInternalServerErrorBody secret create libpod internal server error body
swagger:model SecretCreateLibpodInternalServerErrorBody
*/
type SecretCreateLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this secret create libpod internal server error body
func (o *SecretCreateLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this secret create libpod internal server error body based on context it is used
func (o *SecretCreateLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SecretCreateLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecretCreateLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res SecretCreateLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
