// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewContainerPruneLibpodParams creates a new ContainerPruneLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerPruneLibpodParams() *ContainerPruneLibpodParams {
	return &ContainerPruneLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerPruneLibpodParamsWithTimeout creates a new ContainerPruneLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerPruneLibpodParamsWithTimeout(timeout time.Duration) *ContainerPruneLibpodParams {
	return &ContainerPruneLibpodParams{
		timeout: timeout,
	}
}

// NewContainerPruneLibpodParamsWithContext creates a new ContainerPruneLibpodParams object
// with the ability to set a context for a request.
func NewContainerPruneLibpodParamsWithContext(ctx context.Context) *ContainerPruneLibpodParams {
	return &ContainerPruneLibpodParams{
		Context: ctx,
	}
}

// NewContainerPruneLibpodParamsWithHTTPClient creates a new ContainerPruneLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerPruneLibpodParamsWithHTTPClient(client *http.Client) *ContainerPruneLibpodParams {
	return &ContainerPruneLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerPruneLibpodParams contains all the parameters to send to the API endpoint

	for the container prune libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerPruneLibpodParams struct {

	/* Filters.

	    Filters to process on the prune list, encoded as JSON (a `map[string][]string`).  Available filters:
	- `until=<timestamp>` Prune containers created before this timestamp. The `<timestamp>` can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. `10m`, `1h30m`) computed relative to the daemon machine’s time.
	- `label` (`label=<key>`, `label=<key>=<value>`, `label!=<key>`, or `label!=<key>=<value>`) Prune containers with (or without, in case `label!=...` is used) the specified labels.

	*/
	Filters *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container prune libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerPruneLibpodParams) WithDefaults() *ContainerPruneLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container prune libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerPruneLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the container prune libpod params
func (o *ContainerPruneLibpodParams) WithTimeout(timeout time.Duration) *ContainerPruneLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container prune libpod params
func (o *ContainerPruneLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container prune libpod params
func (o *ContainerPruneLibpodParams) WithContext(ctx context.Context) *ContainerPruneLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container prune libpod params
func (o *ContainerPruneLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container prune libpod params
func (o *ContainerPruneLibpodParams) WithHTTPClient(client *http.Client) *ContainerPruneLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container prune libpod params
func (o *ContainerPruneLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilters adds the filters to the container prune libpod params
func (o *ContainerPruneLibpodParams) WithFilters(filters *string) *ContainerPruneLibpodParams {
	o.SetFilters(filters)
	return o
}

// SetFilters adds the filters to the container prune libpod params
func (o *ContainerPruneLibpodParams) SetFilters(filters *string) {
	o.Filters = filters
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerPruneLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filters != nil {

		// query param filters
		var qrFilters string

		if o.Filters != nil {
			qrFilters = *o.Filters
		}
		qFilters := qrFilters
		if qFilters != "" {

			if err := r.SetQueryParam("filters", qFilters); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
