// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new images API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for images API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ImageBuildLibpod(params *ImageBuildLibpodParams, opts ...ClientOption) (*ImageBuildLibpodOK, error)

	ImageChangesLibpod(params *ImageChangesLibpodParams, opts ...ClientOption) (*ImageChangesLibpodOK, error)

	ImageDeleteAllLibpod(params *ImageDeleteAllLibpodParams, opts ...ClientOption) (*ImageDeleteAllLibpodOK, error)

	ImageDeleteLibpod(params *ImageDeleteLibpodParams, opts ...ClientOption) (*ImageDeleteLibpodOK, error)

	ImageExistsLibpod(params *ImageExistsLibpodParams, opts ...ClientOption) (*ImageExistsLibpodNoContent, error)

	ImageExportLibpod(params *ImageExportLibpodParams, writer io.Writer, opts ...ClientOption) (*ImageExportLibpodOK, error)

	ImageGetLibpod(params *ImageGetLibpodParams, writer io.Writer, opts ...ClientOption) (*ImageGetLibpodOK, error)

	ImageHistoryLibpod(params *ImageHistoryLibpodParams, opts ...ClientOption) (*ImageHistoryLibpodOK, error)

	ImageImportLibpod(params *ImageImportLibpodParams, opts ...ClientOption) (*ImageImportLibpodOK, error)

	ImageInspectLibpod(params *ImageInspectLibpodParams, opts ...ClientOption) (*ImageInspectLibpodOK, error)

	ImageListLibpod(params *ImageListLibpodParams, opts ...ClientOption) (*ImageListLibpodOK, error)

	ImageLoadLibpod(params *ImageLoadLibpodParams, opts ...ClientOption) (*ImageLoadLibpodOK, error)

	ImagePruneLibpod(params *ImagePruneLibpodParams, opts ...ClientOption) (*ImagePruneLibpodOK, error)

	ImagePullLibpod(params *ImagePullLibpodParams, opts ...ClientOption) (*ImagePullLibpodOK, error)

	ImagePushLibpod(params *ImagePushLibpodParams, writer io.Writer, opts ...ClientOption) (*ImagePushLibpodOK, error)

	ImageSearchLibpod(params *ImageSearchLibpodParams, opts ...ClientOption) (*ImageSearchLibpodOK, error)

	ImageTagLibpod(params *ImageTagLibpodParams, opts ...ClientOption) (*ImageTagLibpodCreated, error)

	ImageTreeLibpod(params *ImageTreeLibpodParams, opts ...ClientOption) (*ImageTreeLibpodOK, error)

	ImageUntagLibpod(params *ImageUntagLibpodParams, opts ...ClientOption) (*ImageUntagLibpodCreated, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ImageBuildLibpod creates image

Build an image from the given Dockerfile(s)
*/
func (a *Client) ImageBuildLibpod(params *ImageBuildLibpodParams, opts ...ClientOption) (*ImageBuildLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageBuildLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageBuildLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/build",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageBuildLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageBuildLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageBuildLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	ImageChangesLibpod reports on changes to images s filesystem adds deletes or modifications

	Returns which files in a images's filesystem have been added, deleted, or modified. The Kind of modification can be one of:

0: Modified
1: Added
2: Deleted
*/
func (a *Client) ImageChangesLibpod(params *ImageChangesLibpodParams, opts ...ClientOption) (*ImageChangesLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageChangesLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageChangesLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/images/{name}/changes",
		ProducesMediaTypes: []string{"application/json", "application/octet-stream", "text/plain"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageChangesLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageChangesLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageChangesLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageDeleteAllLibpod removes one or more images from the storage

Remove one or more images from the storage.
*/
func (a *Client) ImageDeleteAllLibpod(params *ImageDeleteAllLibpodParams, opts ...ClientOption) (*ImageDeleteAllLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageDeleteAllLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageDeleteAllLibpod",
		Method:             "DELETE",
		PathPattern:        "/libpod/images/remove",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageDeleteAllLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageDeleteAllLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageDeleteAllLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageDeleteLibpod removes an image from the local storage

Remove an image from the local storage.
*/
func (a *Client) ImageDeleteLibpod(params *ImageDeleteLibpodParams, opts ...ClientOption) (*ImageDeleteLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageDeleteLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageDeleteLibpod",
		Method:             "DELETE",
		PathPattern:        "/libpod/images/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageDeleteLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageDeleteLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageDeleteLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageExistsLibpod images exists

Check if image exists in local store
*/
func (a *Client) ImageExistsLibpod(params *ImageExistsLibpodParams, opts ...ClientOption) (*ImageExistsLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageExistsLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageExistsLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/images/{name}/exists",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageExistsLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageExistsLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageExistsLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageExportLibpod exports multiple images

Export multiple images into a single object. Only `docker-archive` is currently supported.
*/
func (a *Client) ImageExportLibpod(params *ImageExportLibpodParams, writer io.Writer, opts ...ClientOption) (*ImageExportLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageExportLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageExportLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/images/export",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageExportLibpodReader{formats: a.formats, writer: writer},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageExportLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageExportLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageGetLibpod exports an image

Export an image
*/
func (a *Client) ImageGetLibpod(params *ImageGetLibpodParams, writer io.Writer, opts ...ClientOption) (*ImageGetLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageGetLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageGetLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/images/{name}/get",
		ProducesMediaTypes: []string{"application/x-tar"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageGetLibpodReader{formats: a.formats, writer: writer},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageGetLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageGetLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageHistoryLibpod histories of an image

Return parent layers of an image.
*/
func (a *Client) ImageHistoryLibpod(params *ImageHistoryLibpodParams, opts ...ClientOption) (*ImageHistoryLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageHistoryLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageHistoryLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/images/{name}/history",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageHistoryLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageHistoryLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageHistoryLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageImportLibpod imports image

Import a previously exported tarball as an image.
*/
func (a *Client) ImageImportLibpod(params *ImageImportLibpodParams, opts ...ClientOption) (*ImageImportLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageImportLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageImportLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/images/import",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageImportLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageImportLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageImportLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageInspectLibpod inspects an image

Obtain low-level information about an image
*/
func (a *Client) ImageInspectLibpod(params *ImageInspectLibpodParams, opts ...ClientOption) (*ImageInspectLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageInspectLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageInspectLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/images/{name}/json",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageInspectLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageInspectLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageInspectLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageListLibpod lists images

Returns a list of images on the server
*/
func (a *Client) ImageListLibpod(params *ImageListLibpodParams, opts ...ClientOption) (*ImageListLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageListLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageListLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/images/json",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageListLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageListLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageListLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageLoadLibpod loads image

Load an image (oci-archive or docker-archive) stream.
*/
func (a *Client) ImageLoadLibpod(params *ImageLoadLibpodParams, opts ...ClientOption) (*ImageLoadLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageLoadLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageLoadLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/images/load",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageLoadLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageLoadLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageLoadLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImagePruneLibpod prunes unused images

Remove images that are not being used by a container
*/
func (a *Client) ImagePruneLibpod(params *ImagePruneLibpodParams, opts ...ClientOption) (*ImagePruneLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImagePruneLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImagePruneLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/images/prune",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImagePruneLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImagePruneLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImagePruneLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImagePullLibpod pulls images

Pull one or more images from a container registry.
*/
func (a *Client) ImagePullLibpod(params *ImagePullLibpodParams, opts ...ClientOption) (*ImagePullLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImagePullLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImagePullLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/images/pull",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImagePullLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImagePullLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImagePullLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImagePushLibpod pushes image

Push an image to a container registry
*/
func (a *Client) ImagePushLibpod(params *ImagePushLibpodParams, writer io.Writer, opts ...ClientOption) (*ImagePushLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImagePushLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImagePushLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/images/{name}/push",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImagePushLibpodReader{formats: a.formats, writer: writer},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImagePushLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImagePushLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageSearchLibpod searches images

Search registries for images
*/
func (a *Client) ImageSearchLibpod(params *ImageSearchLibpodParams, opts ...ClientOption) (*ImageSearchLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageSearchLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageSearchLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/images/search",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageSearchLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageSearchLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageSearchLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageTagLibpod tags an image

Tag an image so that it becomes part of a repository.
*/
func (a *Client) ImageTagLibpod(params *ImageTagLibpodParams, opts ...ClientOption) (*ImageTagLibpodCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageTagLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageTagLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/images/{name}/tag",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageTagLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageTagLibpodCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageTagLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageTreeLibpod images tree

Retrieve the image tree for the provided image name or ID
*/
func (a *Client) ImageTreeLibpod(params *ImageTreeLibpodParams, opts ...ClientOption) (*ImageTreeLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageTreeLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageTreeLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/images/{name}/tree",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageTreeLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageTreeLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageTreeLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ImageUntagLibpod untags an image

Untag an image. If not repo and tag are specified, all tags are removed from the image.
*/
func (a *Client) ImageUntagLibpod(params *ImageUntagLibpodParams, opts ...ClientOption) (*ImageUntagLibpodCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewImageUntagLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ImageUntagLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/images/{name}/untag",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ImageUntagLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ImageUntagLibpodCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ImageUntagLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
