// Code generated by go-swagger; DO NOT EDIT.

package pods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// PodPruneLibpodReader is a Reader for the PodPruneLibpod structure.
type PodPruneLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PodPruneLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPodPruneLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPodPruneLibpodBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewPodPruneLibpodConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPodPruneLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewPodPruneLibpodOK creates a PodPruneLibpodOK with default headers values
func NewPodPruneLibpodOK() *PodPruneLibpodOK {
	return &PodPruneLibpodOK{}
}

/*
PodPruneLibpodOK describes a response with status code 200, with default header values.

Prune pod
*/
type PodPruneLibpodOK struct {
	Payload *models.PodPruneReport
}

// IsSuccess returns true when this pod prune libpod o k response has a 2xx status code
func (o *PodPruneLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this pod prune libpod o k response has a 3xx status code
func (o *PodPruneLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod prune libpod o k response has a 4xx status code
func (o *PodPruneLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod prune libpod o k response has a 5xx status code
func (o *PodPruneLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this pod prune libpod o k response a status code equal to that given
func (o *PodPruneLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *PodPruneLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/prune][%d] podPruneLibpodOK  %+v", 200, o.Payload)
}

func (o *PodPruneLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/pods/prune][%d] podPruneLibpodOK  %+v", 200, o.Payload)
}

func (o *PodPruneLibpodOK) GetPayload() *models.PodPruneReport {
	return o.Payload
}

func (o *PodPruneLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PodPruneReport)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodPruneLibpodBadRequest creates a PodPruneLibpodBadRequest with default headers values
func NewPodPruneLibpodBadRequest() *PodPruneLibpodBadRequest {
	return &PodPruneLibpodBadRequest{}
}

/*
PodPruneLibpodBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type PodPruneLibpodBadRequest struct {
	Payload *PodPruneLibpodBadRequestBody
}

// IsSuccess returns true when this pod prune libpod bad request response has a 2xx status code
func (o *PodPruneLibpodBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod prune libpod bad request response has a 3xx status code
func (o *PodPruneLibpodBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod prune libpod bad request response has a 4xx status code
func (o *PodPruneLibpodBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod prune libpod bad request response has a 5xx status code
func (o *PodPruneLibpodBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this pod prune libpod bad request response a status code equal to that given
func (o *PodPruneLibpodBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *PodPruneLibpodBadRequest) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/prune][%d] podPruneLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *PodPruneLibpodBadRequest) String() string {
	return fmt.Sprintf("[POST /libpod/pods/prune][%d] podPruneLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *PodPruneLibpodBadRequest) GetPayload() *PodPruneLibpodBadRequestBody {
	return o.Payload
}

func (o *PodPruneLibpodBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodPruneLibpodBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodPruneLibpodConflict creates a PodPruneLibpodConflict with default headers values
func NewPodPruneLibpodConflict() *PodPruneLibpodConflict {
	return &PodPruneLibpodConflict{}
}

/*
PodPruneLibpodConflict describes a response with status code 409, with default header values.

pod already exists
*/
type PodPruneLibpodConflict struct {
}

// IsSuccess returns true when this pod prune libpod conflict response has a 2xx status code
func (o *PodPruneLibpodConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod prune libpod conflict response has a 3xx status code
func (o *PodPruneLibpodConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod prune libpod conflict response has a 4xx status code
func (o *PodPruneLibpodConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod prune libpod conflict response has a 5xx status code
func (o *PodPruneLibpodConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this pod prune libpod conflict response a status code equal to that given
func (o *PodPruneLibpodConflict) IsCode(code int) bool {
	return code == 409
}

func (o *PodPruneLibpodConflict) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/prune][%d] podPruneLibpodConflict ", 409)
}

func (o *PodPruneLibpodConflict) String() string {
	return fmt.Sprintf("[POST /libpod/pods/prune][%d] podPruneLibpodConflict ", 409)
}

func (o *PodPruneLibpodConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPodPruneLibpodInternalServerError creates a PodPruneLibpodInternalServerError with default headers values
func NewPodPruneLibpodInternalServerError() *PodPruneLibpodInternalServerError {
	return &PodPruneLibpodInternalServerError{}
}

/*
PodPruneLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type PodPruneLibpodInternalServerError struct {
	Payload *PodPruneLibpodInternalServerErrorBody
}

// IsSuccess returns true when this pod prune libpod internal server error response has a 2xx status code
func (o *PodPruneLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod prune libpod internal server error response has a 3xx status code
func (o *PodPruneLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod prune libpod internal server error response has a 4xx status code
func (o *PodPruneLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod prune libpod internal server error response has a 5xx status code
func (o *PodPruneLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this pod prune libpod internal server error response a status code equal to that given
func (o *PodPruneLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *PodPruneLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/prune][%d] podPruneLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodPruneLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/pods/prune][%d] podPruneLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodPruneLibpodInternalServerError) GetPayload() *PodPruneLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *PodPruneLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodPruneLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PodPruneLibpodBadRequestBody pod prune libpod bad request body
swagger:model PodPruneLibpodBadRequestBody
*/
type PodPruneLibpodBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod prune libpod bad request body
func (o *PodPruneLibpodBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod prune libpod bad request body based on context it is used
func (o *PodPruneLibpodBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodPruneLibpodBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodPruneLibpodBadRequestBody) UnmarshalBinary(b []byte) error {
	var res PodPruneLibpodBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PodPruneLibpodInternalServerErrorBody pod prune libpod internal server error body
swagger:model PodPruneLibpodInternalServerErrorBody
*/
type PodPruneLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod prune libpod internal server error body
func (o *PodPruneLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod prune libpod internal server error body based on context it is used
func (o *PodPruneLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodPruneLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodPruneLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res PodPruneLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
