// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerStatsReader is a Reader for the ContainerStats structure.
type ContainerStatsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerStatsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewContainerStatsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerStatsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerStatsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerStatsOK creates a ContainerStatsOK with default headers values
func NewContainerStatsOK() *ContainerStatsOK {
	return &ContainerStatsOK{}
}

/*
ContainerStatsOK describes a response with status code 200, with default header values.

OK
*/
type ContainerStatsOK struct {
}

// IsSuccess returns true when this container stats o k response has a 2xx status code
func (o *ContainerStatsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container stats o k response has a 3xx status code
func (o *ContainerStatsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container stats o k response has a 4xx status code
func (o *ContainerStatsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this container stats o k response has a 5xx status code
func (o *ContainerStatsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this container stats o k response a status code equal to that given
func (o *ContainerStatsOK) IsCode(code int) bool {
	return code == 200
}

func (o *ContainerStatsOK) Error() string {
	return fmt.Sprintf("[GET /containers/{name}/stats][%d] containerStatsOK ", 200)
}

func (o *ContainerStatsOK) String() string {
	return fmt.Sprintf("[GET /containers/{name}/stats][%d] containerStatsOK ", 200)
}

func (o *ContainerStatsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerStatsNotFound creates a ContainerStatsNotFound with default headers values
func NewContainerStatsNotFound() *ContainerStatsNotFound {
	return &ContainerStatsNotFound{}
}

/*
ContainerStatsNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerStatsNotFound struct {
	Payload *ContainerStatsNotFoundBody
}

// IsSuccess returns true when this container stats not found response has a 2xx status code
func (o *ContainerStatsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container stats not found response has a 3xx status code
func (o *ContainerStatsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container stats not found response has a 4xx status code
func (o *ContainerStatsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container stats not found response has a 5xx status code
func (o *ContainerStatsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container stats not found response a status code equal to that given
func (o *ContainerStatsNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerStatsNotFound) Error() string {
	return fmt.Sprintf("[GET /containers/{name}/stats][%d] containerStatsNotFound  %+v", 404, o.Payload)
}

func (o *ContainerStatsNotFound) String() string {
	return fmt.Sprintf("[GET /containers/{name}/stats][%d] containerStatsNotFound  %+v", 404, o.Payload)
}

func (o *ContainerStatsNotFound) GetPayload() *ContainerStatsNotFoundBody {
	return o.Payload
}

func (o *ContainerStatsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerStatsNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerStatsInternalServerError creates a ContainerStatsInternalServerError with default headers values
func NewContainerStatsInternalServerError() *ContainerStatsInternalServerError {
	return &ContainerStatsInternalServerError{}
}

/*
ContainerStatsInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerStatsInternalServerError struct {
	Payload *ContainerStatsInternalServerErrorBody
}

// IsSuccess returns true when this container stats internal server error response has a 2xx status code
func (o *ContainerStatsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container stats internal server error response has a 3xx status code
func (o *ContainerStatsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container stats internal server error response has a 4xx status code
func (o *ContainerStatsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container stats internal server error response has a 5xx status code
func (o *ContainerStatsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container stats internal server error response a status code equal to that given
func (o *ContainerStatsInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerStatsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /containers/{name}/stats][%d] containerStatsInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerStatsInternalServerError) String() string {
	return fmt.Sprintf("[GET /containers/{name}/stats][%d] containerStatsInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerStatsInternalServerError) GetPayload() *ContainerStatsInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerStatsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerStatsInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerStatsInternalServerErrorBody container stats internal server error body
swagger:model ContainerStatsInternalServerErrorBody
*/
type ContainerStatsInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container stats internal server error body
func (o *ContainerStatsInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container stats internal server error body based on context it is used
func (o *ContainerStatsInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerStatsInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerStatsInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerStatsInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerStatsNotFoundBody container stats not found body
swagger:model ContainerStatsNotFoundBody
*/
type ContainerStatsNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container stats not found body
func (o *ContainerStatsNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container stats not found body based on context it is used
func (o *ContainerStatsNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerStatsNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerStatsNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerStatsNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
