// Code generated by go-swagger; DO NOT EDIT.

package networks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// NetworkDeleteLibpodReader is a Reader for the NetworkDeleteLibpod structure.
type NetworkDeleteLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkDeleteLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkDeleteLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewNetworkDeleteLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewNetworkDeleteLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewNetworkDeleteLibpodOK creates a NetworkDeleteLibpodOK with default headers values
func NewNetworkDeleteLibpodOK() *NetworkDeleteLibpodOK {
	return &NetworkDeleteLibpodOK{}
}

/*
NetworkDeleteLibpodOK describes a response with status code 200, with default header values.

Network rm
*/
type NetworkDeleteLibpodOK struct {
	Payload []*models.NetworkRmReport
}

// IsSuccess returns true when this network delete libpod o k response has a 2xx status code
func (o *NetworkDeleteLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network delete libpod o k response has a 3xx status code
func (o *NetworkDeleteLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network delete libpod o k response has a 4xx status code
func (o *NetworkDeleteLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network delete libpod o k response has a 5xx status code
func (o *NetworkDeleteLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network delete libpod o k response a status code equal to that given
func (o *NetworkDeleteLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *NetworkDeleteLibpodOK) Error() string {
	return fmt.Sprintf("[DELETE /libpod/networks/{name}][%d] networkDeleteLibpodOK  %+v", 200, o.Payload)
}

func (o *NetworkDeleteLibpodOK) String() string {
	return fmt.Sprintf("[DELETE /libpod/networks/{name}][%d] networkDeleteLibpodOK  %+v", 200, o.Payload)
}

func (o *NetworkDeleteLibpodOK) GetPayload() []*models.NetworkRmReport {
	return o.Payload
}

func (o *NetworkDeleteLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkDeleteLibpodNotFound creates a NetworkDeleteLibpodNotFound with default headers values
func NewNetworkDeleteLibpodNotFound() *NetworkDeleteLibpodNotFound {
	return &NetworkDeleteLibpodNotFound{}
}

/*
NetworkDeleteLibpodNotFound describes a response with status code 404, with default header values.

No such network
*/
type NetworkDeleteLibpodNotFound struct {
	Payload *NetworkDeleteLibpodNotFoundBody
}

// IsSuccess returns true when this network delete libpod not found response has a 2xx status code
func (o *NetworkDeleteLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network delete libpod not found response has a 3xx status code
func (o *NetworkDeleteLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network delete libpod not found response has a 4xx status code
func (o *NetworkDeleteLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this network delete libpod not found response has a 5xx status code
func (o *NetworkDeleteLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this network delete libpod not found response a status code equal to that given
func (o *NetworkDeleteLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *NetworkDeleteLibpodNotFound) Error() string {
	return fmt.Sprintf("[DELETE /libpod/networks/{name}][%d] networkDeleteLibpodNotFound  %+v", 404, o.Payload)
}

func (o *NetworkDeleteLibpodNotFound) String() string {
	return fmt.Sprintf("[DELETE /libpod/networks/{name}][%d] networkDeleteLibpodNotFound  %+v", 404, o.Payload)
}

func (o *NetworkDeleteLibpodNotFound) GetPayload() *NetworkDeleteLibpodNotFoundBody {
	return o.Payload
}

func (o *NetworkDeleteLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkDeleteLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkDeleteLibpodInternalServerError creates a NetworkDeleteLibpodInternalServerError with default headers values
func NewNetworkDeleteLibpodInternalServerError() *NetworkDeleteLibpodInternalServerError {
	return &NetworkDeleteLibpodInternalServerError{}
}

/*
NetworkDeleteLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type NetworkDeleteLibpodInternalServerError struct {
	Payload *NetworkDeleteLibpodInternalServerErrorBody
}

// IsSuccess returns true when this network delete libpod internal server error response has a 2xx status code
func (o *NetworkDeleteLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network delete libpod internal server error response has a 3xx status code
func (o *NetworkDeleteLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network delete libpod internal server error response has a 4xx status code
func (o *NetworkDeleteLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this network delete libpod internal server error response has a 5xx status code
func (o *NetworkDeleteLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this network delete libpod internal server error response a status code equal to that given
func (o *NetworkDeleteLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *NetworkDeleteLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /libpod/networks/{name}][%d] networkDeleteLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkDeleteLibpodInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /libpod/networks/{name}][%d] networkDeleteLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkDeleteLibpodInternalServerError) GetPayload() *NetworkDeleteLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *NetworkDeleteLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkDeleteLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NetworkDeleteLibpodInternalServerErrorBody network delete libpod internal server error body
swagger:model NetworkDeleteLibpodInternalServerErrorBody
*/
type NetworkDeleteLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network delete libpod internal server error body
func (o *NetworkDeleteLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network delete libpod internal server error body based on context it is used
func (o *NetworkDeleteLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkDeleteLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkDeleteLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res NetworkDeleteLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NetworkDeleteLibpodNotFoundBody network delete libpod not found body
swagger:model NetworkDeleteLibpodNotFoundBody
*/
type NetworkDeleteLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network delete libpod not found body
func (o *NetworkDeleteLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network delete libpod not found body based on context it is used
func (o *NetworkDeleteLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkDeleteLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkDeleteLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res NetworkDeleteLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
