// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageChangesLibpodReader is a Reader for the ImageChangesLibpod structure.
type ImageChangesLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImageChangesLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImageChangesLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewImageChangesLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageChangesLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageChangesLibpodOK creates a ImageChangesLibpodOK with default headers values
func NewImageChangesLibpodOK() *ImageChangesLibpodOK {
	return &ImageChangesLibpodOK{}
}

/*
ImageChangesLibpodOK describes a response with status code 200, with default header values.

Array of Changes
*/
type ImageChangesLibpodOK struct {
}

// IsSuccess returns true when this image changes libpod o k response has a 2xx status code
func (o *ImageChangesLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image changes libpod o k response has a 3xx status code
func (o *ImageChangesLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image changes libpod o k response has a 4xx status code
func (o *ImageChangesLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image changes libpod o k response has a 5xx status code
func (o *ImageChangesLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image changes libpod o k response a status code equal to that given
func (o *ImageChangesLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImageChangesLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/changes][%d] imageChangesLibpodOK ", 200)
}

func (o *ImageChangesLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/changes][%d] imageChangesLibpodOK ", 200)
}

func (o *ImageChangesLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewImageChangesLibpodNotFound creates a ImageChangesLibpodNotFound with default headers values
func NewImageChangesLibpodNotFound() *ImageChangesLibpodNotFound {
	return &ImageChangesLibpodNotFound{}
}

/*
ImageChangesLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ImageChangesLibpodNotFound struct {
	Payload *ImageChangesLibpodNotFoundBody
}

// IsSuccess returns true when this image changes libpod not found response has a 2xx status code
func (o *ImageChangesLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image changes libpod not found response has a 3xx status code
func (o *ImageChangesLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image changes libpod not found response has a 4xx status code
func (o *ImageChangesLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this image changes libpod not found response has a 5xx status code
func (o *ImageChangesLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this image changes libpod not found response a status code equal to that given
func (o *ImageChangesLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ImageChangesLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/changes][%d] imageChangesLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ImageChangesLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/changes][%d] imageChangesLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ImageChangesLibpodNotFound) GetPayload() *ImageChangesLibpodNotFoundBody {
	return o.Payload
}

func (o *ImageChangesLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageChangesLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageChangesLibpodInternalServerError creates a ImageChangesLibpodInternalServerError with default headers values
func NewImageChangesLibpodInternalServerError() *ImageChangesLibpodInternalServerError {
	return &ImageChangesLibpodInternalServerError{}
}

/*
ImageChangesLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageChangesLibpodInternalServerError struct {
	Payload *ImageChangesLibpodInternalServerErrorBody
}

// IsSuccess returns true when this image changes libpod internal server error response has a 2xx status code
func (o *ImageChangesLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image changes libpod internal server error response has a 3xx status code
func (o *ImageChangesLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image changes libpod internal server error response has a 4xx status code
func (o *ImageChangesLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image changes libpod internal server error response has a 5xx status code
func (o *ImageChangesLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image changes libpod internal server error response a status code equal to that given
func (o *ImageChangesLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageChangesLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/changes][%d] imageChangesLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageChangesLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/changes][%d] imageChangesLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageChangesLibpodInternalServerError) GetPayload() *ImageChangesLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ImageChangesLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageChangesLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageChangesLibpodInternalServerErrorBody image changes libpod internal server error body
swagger:model ImageChangesLibpodInternalServerErrorBody
*/
type ImageChangesLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image changes libpod internal server error body
func (o *ImageChangesLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image changes libpod internal server error body based on context it is used
func (o *ImageChangesLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageChangesLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageChangesLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageChangesLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageChangesLibpodNotFoundBody image changes libpod not found body
swagger:model ImageChangesLibpodNotFoundBody
*/
type ImageChangesLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image changes libpod not found body
func (o *ImageChangesLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image changes libpod not found body based on context it is used
func (o *ImageChangesLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageChangesLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageChangesLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ImageChangesLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
