// Code generated by go-swagger; DO NOT EDIT.

package pods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// PodCreateLibpodReader is a Reader for the PodCreateLibpod structure.
type PodCreateLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PodCreateLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewPodCreateLibpodCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPodCreateLibpodBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewPodCreateLibpodConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPodCreateLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewPodCreateLibpodCreated creates a PodCreateLibpodCreated with default headers values
func NewPodCreateLibpodCreated() *PodCreateLibpodCreated {
	return &PodCreateLibpodCreated{}
}

/*
PodCreateLibpodCreated describes a response with status code 201, with default header values.

PodCreateLibpodCreated pod create libpod created
*/
type PodCreateLibpodCreated struct {
	Payload *models.IDResponse
}

// IsSuccess returns true when this pod create libpod created response has a 2xx status code
func (o *PodCreateLibpodCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this pod create libpod created response has a 3xx status code
func (o *PodCreateLibpodCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod create libpod created response has a 4xx status code
func (o *PodCreateLibpodCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod create libpod created response has a 5xx status code
func (o *PodCreateLibpodCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this pod create libpod created response a status code equal to that given
func (o *PodCreateLibpodCreated) IsCode(code int) bool {
	return code == 201
}

func (o *PodCreateLibpodCreated) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/create][%d] podCreateLibpodCreated  %+v", 201, o.Payload)
}

func (o *PodCreateLibpodCreated) String() string {
	return fmt.Sprintf("[POST /libpod/pods/create][%d] podCreateLibpodCreated  %+v", 201, o.Payload)
}

func (o *PodCreateLibpodCreated) GetPayload() *models.IDResponse {
	return o.Payload
}

func (o *PodCreateLibpodCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.IDResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodCreateLibpodBadRequest creates a PodCreateLibpodBadRequest with default headers values
func NewPodCreateLibpodBadRequest() *PodCreateLibpodBadRequest {
	return &PodCreateLibpodBadRequest{}
}

/*
PodCreateLibpodBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type PodCreateLibpodBadRequest struct {
	Payload *PodCreateLibpodBadRequestBody
}

// IsSuccess returns true when this pod create libpod bad request response has a 2xx status code
func (o *PodCreateLibpodBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod create libpod bad request response has a 3xx status code
func (o *PodCreateLibpodBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod create libpod bad request response has a 4xx status code
func (o *PodCreateLibpodBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod create libpod bad request response has a 5xx status code
func (o *PodCreateLibpodBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this pod create libpod bad request response a status code equal to that given
func (o *PodCreateLibpodBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *PodCreateLibpodBadRequest) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/create][%d] podCreateLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *PodCreateLibpodBadRequest) String() string {
	return fmt.Sprintf("[POST /libpod/pods/create][%d] podCreateLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *PodCreateLibpodBadRequest) GetPayload() *PodCreateLibpodBadRequestBody {
	return o.Payload
}

func (o *PodCreateLibpodBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodCreateLibpodBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodCreateLibpodConflict creates a PodCreateLibpodConflict with default headers values
func NewPodCreateLibpodConflict() *PodCreateLibpodConflict {
	return &PodCreateLibpodConflict{}
}

/*
PodCreateLibpodConflict describes a response with status code 409, with default header values.

status conflict
*/
type PodCreateLibpodConflict struct {
	Payload string
}

// IsSuccess returns true when this pod create libpod conflict response has a 2xx status code
func (o *PodCreateLibpodConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod create libpod conflict response has a 3xx status code
func (o *PodCreateLibpodConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod create libpod conflict response has a 4xx status code
func (o *PodCreateLibpodConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod create libpod conflict response has a 5xx status code
func (o *PodCreateLibpodConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this pod create libpod conflict response a status code equal to that given
func (o *PodCreateLibpodConflict) IsCode(code int) bool {
	return code == 409
}

func (o *PodCreateLibpodConflict) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/create][%d] podCreateLibpodConflict  %+v", 409, o.Payload)
}

func (o *PodCreateLibpodConflict) String() string {
	return fmt.Sprintf("[POST /libpod/pods/create][%d] podCreateLibpodConflict  %+v", 409, o.Payload)
}

func (o *PodCreateLibpodConflict) GetPayload() string {
	return o.Payload
}

func (o *PodCreateLibpodConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodCreateLibpodInternalServerError creates a PodCreateLibpodInternalServerError with default headers values
func NewPodCreateLibpodInternalServerError() *PodCreateLibpodInternalServerError {
	return &PodCreateLibpodInternalServerError{}
}

/*
PodCreateLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type PodCreateLibpodInternalServerError struct {
	Payload *PodCreateLibpodInternalServerErrorBody
}

// IsSuccess returns true when this pod create libpod internal server error response has a 2xx status code
func (o *PodCreateLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod create libpod internal server error response has a 3xx status code
func (o *PodCreateLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod create libpod internal server error response has a 4xx status code
func (o *PodCreateLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod create libpod internal server error response has a 5xx status code
func (o *PodCreateLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this pod create libpod internal server error response a status code equal to that given
func (o *PodCreateLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *PodCreateLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/create][%d] podCreateLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodCreateLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/pods/create][%d] podCreateLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodCreateLibpodInternalServerError) GetPayload() *PodCreateLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *PodCreateLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodCreateLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PodCreateLibpodBadRequestBody pod create libpod bad request body
swagger:model PodCreateLibpodBadRequestBody
*/
type PodCreateLibpodBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod create libpod bad request body
func (o *PodCreateLibpodBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod create libpod bad request body based on context it is used
func (o *PodCreateLibpodBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodCreateLibpodBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodCreateLibpodBadRequestBody) UnmarshalBinary(b []byte) error {
	var res PodCreateLibpodBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PodCreateLibpodInternalServerErrorBody pod create libpod internal server error body
swagger:model PodCreateLibpodInternalServerErrorBody
*/
type PodCreateLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod create libpod internal server error body
func (o *PodCreateLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod create libpod internal server error body based on context it is used
func (o *PodCreateLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodCreateLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodCreateLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res PodCreateLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
