// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerAttachLibpodParams creates a new ContainerAttachLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerAttachLibpodParams() *ContainerAttachLibpodParams {
	return &ContainerAttachLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerAttachLibpodParamsWithTimeout creates a new ContainerAttachLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerAttachLibpodParamsWithTimeout(timeout time.Duration) *ContainerAttachLibpodParams {
	return &ContainerAttachLibpodParams{
		timeout: timeout,
	}
}

// NewContainerAttachLibpodParamsWithContext creates a new ContainerAttachLibpodParams object
// with the ability to set a context for a request.
func NewContainerAttachLibpodParamsWithContext(ctx context.Context) *ContainerAttachLibpodParams {
	return &ContainerAttachLibpodParams{
		Context: ctx,
	}
}

// NewContainerAttachLibpodParamsWithHTTPClient creates a new ContainerAttachLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerAttachLibpodParamsWithHTTPClient(client *http.Client) *ContainerAttachLibpodParams {
	return &ContainerAttachLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerAttachLibpodParams contains all the parameters to send to the API endpoint

	for the container attach libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerAttachLibpodParams struct {

	/* DetachKeys.

	   keys to use for detaching from the container
	*/
	DetachKeys *string

	/* Logs.

	   Stream all logs from the container across the connection. Happens before streaming attach (if requested). At least one of logs or stream must be set
	*/
	Logs *bool

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* Stderr.

	   Attach to container STDERR
	*/
	Stderr *bool

	/* Stdin.

	   Attach to container STDIN
	*/
	Stdin *bool

	/* Stdout.

	   Attach to container STDOUT
	*/
	Stdout *bool

	/* Stream.

	   Attach to the container. If unset, and logs is set, only the container's logs will be sent. At least one of stream or logs must be set

	   Default: true
	*/
	Stream *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container attach libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerAttachLibpodParams) WithDefaults() *ContainerAttachLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container attach libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerAttachLibpodParams) SetDefaults() {
	var (
		streamDefault = bool(true)
	)

	val := ContainerAttachLibpodParams{
		Stream: &streamDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the container attach libpod params
func (o *ContainerAttachLibpodParams) WithTimeout(timeout time.Duration) *ContainerAttachLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container attach libpod params
func (o *ContainerAttachLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container attach libpod params
func (o *ContainerAttachLibpodParams) WithContext(ctx context.Context) *ContainerAttachLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container attach libpod params
func (o *ContainerAttachLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container attach libpod params
func (o *ContainerAttachLibpodParams) WithHTTPClient(client *http.Client) *ContainerAttachLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container attach libpod params
func (o *ContainerAttachLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDetachKeys adds the detachKeys to the container attach libpod params
func (o *ContainerAttachLibpodParams) WithDetachKeys(detachKeys *string) *ContainerAttachLibpodParams {
	o.SetDetachKeys(detachKeys)
	return o
}

// SetDetachKeys adds the detachKeys to the container attach libpod params
func (o *ContainerAttachLibpodParams) SetDetachKeys(detachKeys *string) {
	o.DetachKeys = detachKeys
}

// WithLogs adds the logs to the container attach libpod params
func (o *ContainerAttachLibpodParams) WithLogs(logs *bool) *ContainerAttachLibpodParams {
	o.SetLogs(logs)
	return o
}

// SetLogs adds the logs to the container attach libpod params
func (o *ContainerAttachLibpodParams) SetLogs(logs *bool) {
	o.Logs = logs
}

// WithName adds the name to the container attach libpod params
func (o *ContainerAttachLibpodParams) WithName(name string) *ContainerAttachLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container attach libpod params
func (o *ContainerAttachLibpodParams) SetName(name string) {
	o.Name = name
}

// WithStderr adds the stderr to the container attach libpod params
func (o *ContainerAttachLibpodParams) WithStderr(stderr *bool) *ContainerAttachLibpodParams {
	o.SetStderr(stderr)
	return o
}

// SetStderr adds the stderr to the container attach libpod params
func (o *ContainerAttachLibpodParams) SetStderr(stderr *bool) {
	o.Stderr = stderr
}

// WithStdin adds the stdin to the container attach libpod params
func (o *ContainerAttachLibpodParams) WithStdin(stdin *bool) *ContainerAttachLibpodParams {
	o.SetStdin(stdin)
	return o
}

// SetStdin adds the stdin to the container attach libpod params
func (o *ContainerAttachLibpodParams) SetStdin(stdin *bool) {
	o.Stdin = stdin
}

// WithStdout adds the stdout to the container attach libpod params
func (o *ContainerAttachLibpodParams) WithStdout(stdout *bool) *ContainerAttachLibpodParams {
	o.SetStdout(stdout)
	return o
}

// SetStdout adds the stdout to the container attach libpod params
func (o *ContainerAttachLibpodParams) SetStdout(stdout *bool) {
	o.Stdout = stdout
}

// WithStream adds the stream to the container attach libpod params
func (o *ContainerAttachLibpodParams) WithStream(stream *bool) *ContainerAttachLibpodParams {
	o.SetStream(stream)
	return o
}

// SetStream adds the stream to the container attach libpod params
func (o *ContainerAttachLibpodParams) SetStream(stream *bool) {
	o.Stream = stream
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerAttachLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DetachKeys != nil {

		// query param detachKeys
		var qrDetachKeys string

		if o.DetachKeys != nil {
			qrDetachKeys = *o.DetachKeys
		}
		qDetachKeys := qrDetachKeys
		if qDetachKeys != "" {

			if err := r.SetQueryParam("detachKeys", qDetachKeys); err != nil {
				return err
			}
		}
	}

	if o.Logs != nil {

		// query param logs
		var qrLogs bool

		if o.Logs != nil {
			qrLogs = *o.Logs
		}
		qLogs := swag.FormatBool(qrLogs)
		if qLogs != "" {

			if err := r.SetQueryParam("logs", qLogs); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Stderr != nil {

		// query param stderr
		var qrStderr bool

		if o.Stderr != nil {
			qrStderr = *o.Stderr
		}
		qStderr := swag.FormatBool(qrStderr)
		if qStderr != "" {

			if err := r.SetQueryParam("stderr", qStderr); err != nil {
				return err
			}
		}
	}

	if o.Stdin != nil {

		// query param stdin
		var qrStdin bool

		if o.Stdin != nil {
			qrStdin = *o.Stdin
		}
		qStdin := swag.FormatBool(qrStdin)
		if qStdin != "" {

			if err := r.SetQueryParam("stdin", qStdin); err != nil {
				return err
			}
		}
	}

	if o.Stdout != nil {

		// query param stdout
		var qrStdout bool

		if o.Stdout != nil {
			qrStdout = *o.Stdout
		}
		qStdout := swag.FormatBool(qrStdout)
		if qStdout != "" {

			if err := r.SetQueryParam("stdout", qStdout); err != nil {
				return err
			}
		}
	}

	if o.Stream != nil {

		// query param stream
		var qrStream bool

		if o.Stream != nil {
			qrStream = *o.Stream
		}
		qStream := swag.FormatBool(qrStream)
		if qStream != "" {

			if err := r.SetQueryParam("stream", qStream); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
