// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerCheckpointLibpodParams creates a new ContainerCheckpointLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerCheckpointLibpodParams() *ContainerCheckpointLibpodParams {
	return &ContainerCheckpointLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerCheckpointLibpodParamsWithTimeout creates a new ContainerCheckpointLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerCheckpointLibpodParamsWithTimeout(timeout time.Duration) *ContainerCheckpointLibpodParams {
	return &ContainerCheckpointLibpodParams{
		timeout: timeout,
	}
}

// NewContainerCheckpointLibpodParamsWithContext creates a new ContainerCheckpointLibpodParams object
// with the ability to set a context for a request.
func NewContainerCheckpointLibpodParamsWithContext(ctx context.Context) *ContainerCheckpointLibpodParams {
	return &ContainerCheckpointLibpodParams{
		Context: ctx,
	}
}

// NewContainerCheckpointLibpodParamsWithHTTPClient creates a new ContainerCheckpointLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerCheckpointLibpodParamsWithHTTPClient(client *http.Client) *ContainerCheckpointLibpodParams {
	return &ContainerCheckpointLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerCheckpointLibpodParams contains all the parameters to send to the API endpoint

	for the container checkpoint libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerCheckpointLibpodParams struct {

	/* Export.

	   export the checkpoint image to a tar.gz
	*/
	Export *bool

	/* IgnoreRootFS.

	   do not include root file-system changes when exporting
	*/
	IgnoreRootFS *bool

	/* Keep.

	   keep all temporary checkpoint files
	*/
	Keep *bool

	/* LeaveRunning.

	   leave the container running after writing checkpoint to disk
	*/
	LeaveRunning *bool

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* PrintStats.

	   add checkpoint statistics to the returned CheckpointReport
	*/
	PrintStats *bool

	/* TCPEstablished.

	   checkpoint a container with established TCP connections
	*/
	TCPEstablished *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container checkpoint libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerCheckpointLibpodParams) WithDefaults() *ContainerCheckpointLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container checkpoint libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerCheckpointLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) WithTimeout(timeout time.Duration) *ContainerCheckpointLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) WithContext(ctx context.Context) *ContainerCheckpointLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) WithHTTPClient(client *http.Client) *ContainerCheckpointLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithExport adds the export to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) WithExport(export *bool) *ContainerCheckpointLibpodParams {
	o.SetExport(export)
	return o
}

// SetExport adds the export to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) SetExport(export *bool) {
	o.Export = export
}

// WithIgnoreRootFS adds the ignoreRootFS to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) WithIgnoreRootFS(ignoreRootFS *bool) *ContainerCheckpointLibpodParams {
	o.SetIgnoreRootFS(ignoreRootFS)
	return o
}

// SetIgnoreRootFS adds the ignoreRootFS to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) SetIgnoreRootFS(ignoreRootFS *bool) {
	o.IgnoreRootFS = ignoreRootFS
}

// WithKeep adds the keep to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) WithKeep(keep *bool) *ContainerCheckpointLibpodParams {
	o.SetKeep(keep)
	return o
}

// SetKeep adds the keep to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) SetKeep(keep *bool) {
	o.Keep = keep
}

// WithLeaveRunning adds the leaveRunning to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) WithLeaveRunning(leaveRunning *bool) *ContainerCheckpointLibpodParams {
	o.SetLeaveRunning(leaveRunning)
	return o
}

// SetLeaveRunning adds the leaveRunning to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) SetLeaveRunning(leaveRunning *bool) {
	o.LeaveRunning = leaveRunning
}

// WithName adds the name to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) WithName(name string) *ContainerCheckpointLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) SetName(name string) {
	o.Name = name
}

// WithPrintStats adds the printStats to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) WithPrintStats(printStats *bool) *ContainerCheckpointLibpodParams {
	o.SetPrintStats(printStats)
	return o
}

// SetPrintStats adds the printStats to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) SetPrintStats(printStats *bool) {
	o.PrintStats = printStats
}

// WithTCPEstablished adds the tCPEstablished to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) WithTCPEstablished(tCPEstablished *bool) *ContainerCheckpointLibpodParams {
	o.SetTCPEstablished(tCPEstablished)
	return o
}

// SetTCPEstablished adds the tcpEstablished to the container checkpoint libpod params
func (o *ContainerCheckpointLibpodParams) SetTCPEstablished(tCPEstablished *bool) {
	o.TCPEstablished = tCPEstablished
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerCheckpointLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Export != nil {

		// query param export
		var qrExport bool

		if o.Export != nil {
			qrExport = *o.Export
		}
		qExport := swag.FormatBool(qrExport)
		if qExport != "" {

			if err := r.SetQueryParam("export", qExport); err != nil {
				return err
			}
		}
	}

	if o.IgnoreRootFS != nil {

		// query param ignoreRootFS
		var qrIgnoreRootFS bool

		if o.IgnoreRootFS != nil {
			qrIgnoreRootFS = *o.IgnoreRootFS
		}
		qIgnoreRootFS := swag.FormatBool(qrIgnoreRootFS)
		if qIgnoreRootFS != "" {

			if err := r.SetQueryParam("ignoreRootFS", qIgnoreRootFS); err != nil {
				return err
			}
		}
	}

	if o.Keep != nil {

		// query param keep
		var qrKeep bool

		if o.Keep != nil {
			qrKeep = *o.Keep
		}
		qKeep := swag.FormatBool(qrKeep)
		if qKeep != "" {

			if err := r.SetQueryParam("keep", qKeep); err != nil {
				return err
			}
		}
	}

	if o.LeaveRunning != nil {

		// query param leaveRunning
		var qrLeaveRunning bool

		if o.LeaveRunning != nil {
			qrLeaveRunning = *o.LeaveRunning
		}
		qLeaveRunning := swag.FormatBool(qrLeaveRunning)
		if qLeaveRunning != "" {

			if err := r.SetQueryParam("leaveRunning", qLeaveRunning); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.PrintStats != nil {

		// query param printStats
		var qrPrintStats bool

		if o.PrintStats != nil {
			qrPrintStats = *o.PrintStats
		}
		qPrintStats := swag.FormatBool(qrPrintStats)
		if qPrintStats != "" {

			if err := r.SetQueryParam("printStats", qPrintStats); err != nil {
				return err
			}
		}
	}

	if o.TCPEstablished != nil {

		// query param tcpEstablished
		var qrTCPEstablished bool

		if o.TCPEstablished != nil {
			qrTCPEstablished = *o.TCPEstablished
		}
		qTCPEstablished := swag.FormatBool(qrTCPEstablished)
		if qTCPEstablished != "" {

			if err := r.SetQueryParam("tcpEstablished", qTCPEstablished); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
