// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerDeleteLibpodParams creates a new ContainerDeleteLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerDeleteLibpodParams() *ContainerDeleteLibpodParams {
	return &ContainerDeleteLibpodParams{
		requestTimeout: cr.DefaultTimeout,
	}
}

// NewContainerDeleteLibpodParamsWithTimeout creates a new ContainerDeleteLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerDeleteLibpodParamsWithTimeout(timeout time.Duration) *ContainerDeleteLibpodParams {
	return &ContainerDeleteLibpodParams{
		requestTimeout: timeout,
	}
}

// NewContainerDeleteLibpodParamsWithContext creates a new ContainerDeleteLibpodParams object
// with the ability to set a context for a request.
func NewContainerDeleteLibpodParamsWithContext(ctx context.Context) *ContainerDeleteLibpodParams {
	return &ContainerDeleteLibpodParams{
		Context: ctx,
	}
}

// NewContainerDeleteLibpodParamsWithHTTPClient creates a new ContainerDeleteLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerDeleteLibpodParamsWithHTTPClient(client *http.Client) *ContainerDeleteLibpodParams {
	return &ContainerDeleteLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerDeleteLibpodParams contains all the parameters to send to the API endpoint

	for the container delete libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerDeleteLibpodParams struct {

	/* Depend.

	   additionally remove containers that depend on the container to be removed
	*/
	Depend *bool

	/* Force.

	   force stop container if running
	*/
	Force *bool

	/* Ignore.

	   ignore errors when the container to be removed does not existxo
	*/
	Ignore *bool

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* Timeout.

	   number of seconds to wait before killing container when force removing

	   Default: 10
	*/
	Timeout *int64

	/* V.

	   delete volumes
	*/
	V *bool

	requestTimeout time.Duration
	Context        context.Context
	HTTPClient     *http.Client
}

// WithDefaults hydrates default values in the container delete libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerDeleteLibpodParams) WithDefaults() *ContainerDeleteLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container delete libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerDeleteLibpodParams) SetDefaults() {
	var (
		timeoutDefault = int64(10)
	)

	val := ContainerDeleteLibpodParams{
		Timeout: &timeoutDefault,
	}

	val.requestTimeout = o.requestTimeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithRequestTimeout adds the timeout to the container delete libpod params
func (o *ContainerDeleteLibpodParams) WithRequestTimeout(timeout time.Duration) *ContainerDeleteLibpodParams {
	o.SetRequestTimeout(timeout)
	return o
}

// SetRequestTimeout adds the timeout to the container delete libpod params
func (o *ContainerDeleteLibpodParams) SetRequestTimeout(timeout time.Duration) {
	o.requestTimeout = timeout
}

// WithContext adds the context to the container delete libpod params
func (o *ContainerDeleteLibpodParams) WithContext(ctx context.Context) *ContainerDeleteLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container delete libpod params
func (o *ContainerDeleteLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container delete libpod params
func (o *ContainerDeleteLibpodParams) WithHTTPClient(client *http.Client) *ContainerDeleteLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container delete libpod params
func (o *ContainerDeleteLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDepend adds the depend to the container delete libpod params
func (o *ContainerDeleteLibpodParams) WithDepend(depend *bool) *ContainerDeleteLibpodParams {
	o.SetDepend(depend)
	return o
}

// SetDepend adds the depend to the container delete libpod params
func (o *ContainerDeleteLibpodParams) SetDepend(depend *bool) {
	o.Depend = depend
}

// WithForce adds the force to the container delete libpod params
func (o *ContainerDeleteLibpodParams) WithForce(force *bool) *ContainerDeleteLibpodParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the container delete libpod params
func (o *ContainerDeleteLibpodParams) SetForce(force *bool) {
	o.Force = force
}

// WithIgnore adds the ignore to the container delete libpod params
func (o *ContainerDeleteLibpodParams) WithIgnore(ignore *bool) *ContainerDeleteLibpodParams {
	o.SetIgnore(ignore)
	return o
}

// SetIgnore adds the ignore to the container delete libpod params
func (o *ContainerDeleteLibpodParams) SetIgnore(ignore *bool) {
	o.Ignore = ignore
}

// WithName adds the name to the container delete libpod params
func (o *ContainerDeleteLibpodParams) WithName(name string) *ContainerDeleteLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container delete libpod params
func (o *ContainerDeleteLibpodParams) SetName(name string) {
	o.Name = name
}

// WithTimeout adds the timeout to the container delete libpod params
func (o *ContainerDeleteLibpodParams) WithTimeout(timeout *int64) *ContainerDeleteLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container delete libpod params
func (o *ContainerDeleteLibpodParams) SetTimeout(timeout *int64) {
	o.Timeout = timeout
}

// WithV adds the v to the container delete libpod params
func (o *ContainerDeleteLibpodParams) WithV(v *bool) *ContainerDeleteLibpodParams {
	o.SetV(v)
	return o
}

// SetV adds the v to the container delete libpod params
func (o *ContainerDeleteLibpodParams) SetV(v *bool) {
	o.V = v
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerDeleteLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.requestTimeout); err != nil {
		return err
	}
	var res []error

	if o.Depend != nil {

		// query param depend
		var qrDepend bool

		if o.Depend != nil {
			qrDepend = *o.Depend
		}
		qDepend := swag.FormatBool(qrDepend)
		if qDepend != "" {

			if err := r.SetQueryParam("depend", qDepend); err != nil {
				return err
			}
		}
	}

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}

	if o.Ignore != nil {

		// query param ignore
		var qrIgnore bool

		if o.Ignore != nil {
			qrIgnore = *o.Ignore
		}
		qIgnore := swag.FormatBool(qrIgnore)
		if qIgnore != "" {

			if err := r.SetQueryParam("ignore", qIgnore); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Timeout != nil {

		// query param timeout
		var qrTimeout int64

		if o.Timeout != nil {
			qrTimeout = *o.Timeout
		}
		qTimeout := swag.FormatInt64(qrTimeout)
		if qTimeout != "" {

			if err := r.SetQueryParam("timeout", qTimeout); err != nil {
				return err
			}
		}
	}

	if o.V != nil {

		// query param v
		var qrV bool

		if o.V != nil {
			qrV = *o.V
		}
		qV := swag.FormatBool(qrV)
		if qV != "" {

			if err := r.SetQueryParam("v", qV); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
