// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerMountLibpodReader is a Reader for the ContainerMountLibpod structure.
type ContainerMountLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerMountLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewContainerMountLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerMountLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerMountLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerMountLibpodOK creates a ContainerMountLibpodOK with default headers values
func NewContainerMountLibpodOK() *ContainerMountLibpodOK {
	return &ContainerMountLibpodOK{}
}

/*
ContainerMountLibpodOK describes a response with status code 200, with default header values.

mounted container
*/
type ContainerMountLibpodOK struct {
	Payload string
}

// IsSuccess returns true when this container mount libpod o k response has a 2xx status code
func (o *ContainerMountLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container mount libpod o k response has a 3xx status code
func (o *ContainerMountLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container mount libpod o k response has a 4xx status code
func (o *ContainerMountLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this container mount libpod o k response has a 5xx status code
func (o *ContainerMountLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this container mount libpod o k response a status code equal to that given
func (o *ContainerMountLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ContainerMountLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/mount][%d] containerMountLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerMountLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/mount][%d] containerMountLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerMountLibpodOK) GetPayload() string {
	return o.Payload
}

func (o *ContainerMountLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerMountLibpodNotFound creates a ContainerMountLibpodNotFound with default headers values
func NewContainerMountLibpodNotFound() *ContainerMountLibpodNotFound {
	return &ContainerMountLibpodNotFound{}
}

/*
ContainerMountLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerMountLibpodNotFound struct {
	Payload *ContainerMountLibpodNotFoundBody
}

// IsSuccess returns true when this container mount libpod not found response has a 2xx status code
func (o *ContainerMountLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container mount libpod not found response has a 3xx status code
func (o *ContainerMountLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container mount libpod not found response has a 4xx status code
func (o *ContainerMountLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container mount libpod not found response has a 5xx status code
func (o *ContainerMountLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container mount libpod not found response a status code equal to that given
func (o *ContainerMountLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerMountLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/mount][%d] containerMountLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerMountLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/mount][%d] containerMountLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerMountLibpodNotFound) GetPayload() *ContainerMountLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerMountLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerMountLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerMountLibpodInternalServerError creates a ContainerMountLibpodInternalServerError with default headers values
func NewContainerMountLibpodInternalServerError() *ContainerMountLibpodInternalServerError {
	return &ContainerMountLibpodInternalServerError{}
}

/*
ContainerMountLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerMountLibpodInternalServerError struct {
	Payload *ContainerMountLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container mount libpod internal server error response has a 2xx status code
func (o *ContainerMountLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container mount libpod internal server error response has a 3xx status code
func (o *ContainerMountLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container mount libpod internal server error response has a 4xx status code
func (o *ContainerMountLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container mount libpod internal server error response has a 5xx status code
func (o *ContainerMountLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container mount libpod internal server error response a status code equal to that given
func (o *ContainerMountLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerMountLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/mount][%d] containerMountLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerMountLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/mount][%d] containerMountLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerMountLibpodInternalServerError) GetPayload() *ContainerMountLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerMountLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerMountLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerMountLibpodInternalServerErrorBody container mount libpod internal server error body
swagger:model ContainerMountLibpodInternalServerErrorBody
*/
type ContainerMountLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container mount libpod internal server error body
func (o *ContainerMountLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container mount libpod internal server error body based on context it is used
func (o *ContainerMountLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerMountLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerMountLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerMountLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerMountLibpodNotFoundBody container mount libpod not found body
swagger:model ContainerMountLibpodNotFoundBody
*/
type ContainerMountLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container mount libpod not found body
func (o *ContainerMountLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container mount libpod not found body based on context it is used
func (o *ContainerMountLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerMountLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerMountLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerMountLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
