// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerRenameLibpodReader is a Reader for the ContainerRenameLibpod structure.
type ContainerRenameLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerRenameLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewContainerRenameLibpodNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerRenameLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewContainerRenameLibpodConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerRenameLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerRenameLibpodNoContent creates a ContainerRenameLibpodNoContent with default headers values
func NewContainerRenameLibpodNoContent() *ContainerRenameLibpodNoContent {
	return &ContainerRenameLibpodNoContent{}
}

/*
ContainerRenameLibpodNoContent describes a response with status code 204, with default header values.

no error
*/
type ContainerRenameLibpodNoContent struct {
}

// IsSuccess returns true when this container rename libpod no content response has a 2xx status code
func (o *ContainerRenameLibpodNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container rename libpod no content response has a 3xx status code
func (o *ContainerRenameLibpodNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container rename libpod no content response has a 4xx status code
func (o *ContainerRenameLibpodNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this container rename libpod no content response has a 5xx status code
func (o *ContainerRenameLibpodNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this container rename libpod no content response a status code equal to that given
func (o *ContainerRenameLibpodNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *ContainerRenameLibpodNoContent) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/rename][%d] containerRenameLibpodNoContent ", 204)
}

func (o *ContainerRenameLibpodNoContent) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/rename][%d] containerRenameLibpodNoContent ", 204)
}

func (o *ContainerRenameLibpodNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerRenameLibpodNotFound creates a ContainerRenameLibpodNotFound with default headers values
func NewContainerRenameLibpodNotFound() *ContainerRenameLibpodNotFound {
	return &ContainerRenameLibpodNotFound{}
}

/*
ContainerRenameLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerRenameLibpodNotFound struct {
	Payload *ContainerRenameLibpodNotFoundBody
}

// IsSuccess returns true when this container rename libpod not found response has a 2xx status code
func (o *ContainerRenameLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container rename libpod not found response has a 3xx status code
func (o *ContainerRenameLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container rename libpod not found response has a 4xx status code
func (o *ContainerRenameLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container rename libpod not found response has a 5xx status code
func (o *ContainerRenameLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container rename libpod not found response a status code equal to that given
func (o *ContainerRenameLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerRenameLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/rename][%d] containerRenameLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerRenameLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/rename][%d] containerRenameLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerRenameLibpodNotFound) GetPayload() *ContainerRenameLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerRenameLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerRenameLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerRenameLibpodConflict creates a ContainerRenameLibpodConflict with default headers values
func NewContainerRenameLibpodConflict() *ContainerRenameLibpodConflict {
	return &ContainerRenameLibpodConflict{}
}

/*
ContainerRenameLibpodConflict describes a response with status code 409, with default header values.

Conflict error in operation
*/
type ContainerRenameLibpodConflict struct {
	Payload *ContainerRenameLibpodConflictBody
}

// IsSuccess returns true when this container rename libpod conflict response has a 2xx status code
func (o *ContainerRenameLibpodConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container rename libpod conflict response has a 3xx status code
func (o *ContainerRenameLibpodConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container rename libpod conflict response has a 4xx status code
func (o *ContainerRenameLibpodConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this container rename libpod conflict response has a 5xx status code
func (o *ContainerRenameLibpodConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this container rename libpod conflict response a status code equal to that given
func (o *ContainerRenameLibpodConflict) IsCode(code int) bool {
	return code == 409
}

func (o *ContainerRenameLibpodConflict) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/rename][%d] containerRenameLibpodConflict  %+v", 409, o.Payload)
}

func (o *ContainerRenameLibpodConflict) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/rename][%d] containerRenameLibpodConflict  %+v", 409, o.Payload)
}

func (o *ContainerRenameLibpodConflict) GetPayload() *ContainerRenameLibpodConflictBody {
	return o.Payload
}

func (o *ContainerRenameLibpodConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerRenameLibpodConflictBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerRenameLibpodInternalServerError creates a ContainerRenameLibpodInternalServerError with default headers values
func NewContainerRenameLibpodInternalServerError() *ContainerRenameLibpodInternalServerError {
	return &ContainerRenameLibpodInternalServerError{}
}

/*
ContainerRenameLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerRenameLibpodInternalServerError struct {
	Payload *ContainerRenameLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container rename libpod internal server error response has a 2xx status code
func (o *ContainerRenameLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container rename libpod internal server error response has a 3xx status code
func (o *ContainerRenameLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container rename libpod internal server error response has a 4xx status code
func (o *ContainerRenameLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container rename libpod internal server error response has a 5xx status code
func (o *ContainerRenameLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container rename libpod internal server error response a status code equal to that given
func (o *ContainerRenameLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerRenameLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/rename][%d] containerRenameLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerRenameLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/rename][%d] containerRenameLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerRenameLibpodInternalServerError) GetPayload() *ContainerRenameLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerRenameLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerRenameLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerRenameLibpodConflictBody container rename libpod conflict body
swagger:model ContainerRenameLibpodConflictBody
*/
type ContainerRenameLibpodConflictBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container rename libpod conflict body
func (o *ContainerRenameLibpodConflictBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container rename libpod conflict body based on context it is used
func (o *ContainerRenameLibpodConflictBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerRenameLibpodConflictBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerRenameLibpodConflictBody) UnmarshalBinary(b []byte) error {
	var res ContainerRenameLibpodConflictBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerRenameLibpodInternalServerErrorBody container rename libpod internal server error body
swagger:model ContainerRenameLibpodInternalServerErrorBody
*/
type ContainerRenameLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container rename libpod internal server error body
func (o *ContainerRenameLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container rename libpod internal server error body based on context it is used
func (o *ContainerRenameLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerRenameLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerRenameLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerRenameLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerRenameLibpodNotFoundBody container rename libpod not found body
swagger:model ContainerRenameLibpodNotFoundBody
*/
type ContainerRenameLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container rename libpod not found body
func (o *ContainerRenameLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container rename libpod not found body based on context it is used
func (o *ContainerRenameLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerRenameLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerRenameLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerRenameLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
