// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerRestartLibpodReader is a Reader for the ContainerRestartLibpod structure.
type ContainerRestartLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerRestartLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewContainerRestartLibpodNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerRestartLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerRestartLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerRestartLibpodNoContent creates a ContainerRestartLibpodNoContent with default headers values
func NewContainerRestartLibpodNoContent() *ContainerRestartLibpodNoContent {
	return &ContainerRestartLibpodNoContent{}
}

/*
ContainerRestartLibpodNoContent describes a response with status code 204, with default header values.

no error
*/
type ContainerRestartLibpodNoContent struct {
}

// IsSuccess returns true when this container restart libpod no content response has a 2xx status code
func (o *ContainerRestartLibpodNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container restart libpod no content response has a 3xx status code
func (o *ContainerRestartLibpodNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container restart libpod no content response has a 4xx status code
func (o *ContainerRestartLibpodNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this container restart libpod no content response has a 5xx status code
func (o *ContainerRestartLibpodNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this container restart libpod no content response a status code equal to that given
func (o *ContainerRestartLibpodNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *ContainerRestartLibpodNoContent) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/restart][%d] containerRestartLibpodNoContent ", 204)
}

func (o *ContainerRestartLibpodNoContent) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/restart][%d] containerRestartLibpodNoContent ", 204)
}

func (o *ContainerRestartLibpodNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerRestartLibpodNotFound creates a ContainerRestartLibpodNotFound with default headers values
func NewContainerRestartLibpodNotFound() *ContainerRestartLibpodNotFound {
	return &ContainerRestartLibpodNotFound{}
}

/*
ContainerRestartLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerRestartLibpodNotFound struct {
	Payload *ContainerRestartLibpodNotFoundBody
}

// IsSuccess returns true when this container restart libpod not found response has a 2xx status code
func (o *ContainerRestartLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container restart libpod not found response has a 3xx status code
func (o *ContainerRestartLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container restart libpod not found response has a 4xx status code
func (o *ContainerRestartLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container restart libpod not found response has a 5xx status code
func (o *ContainerRestartLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container restart libpod not found response a status code equal to that given
func (o *ContainerRestartLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerRestartLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/restart][%d] containerRestartLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerRestartLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/restart][%d] containerRestartLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerRestartLibpodNotFound) GetPayload() *ContainerRestartLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerRestartLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerRestartLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerRestartLibpodInternalServerError creates a ContainerRestartLibpodInternalServerError with default headers values
func NewContainerRestartLibpodInternalServerError() *ContainerRestartLibpodInternalServerError {
	return &ContainerRestartLibpodInternalServerError{}
}

/*
ContainerRestartLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerRestartLibpodInternalServerError struct {
	Payload *ContainerRestartLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container restart libpod internal server error response has a 2xx status code
func (o *ContainerRestartLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container restart libpod internal server error response has a 3xx status code
func (o *ContainerRestartLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container restart libpod internal server error response has a 4xx status code
func (o *ContainerRestartLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container restart libpod internal server error response has a 5xx status code
func (o *ContainerRestartLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container restart libpod internal server error response a status code equal to that given
func (o *ContainerRestartLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerRestartLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/restart][%d] containerRestartLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerRestartLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/restart][%d] containerRestartLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerRestartLibpodInternalServerError) GetPayload() *ContainerRestartLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerRestartLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerRestartLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerRestartLibpodInternalServerErrorBody container restart libpod internal server error body
swagger:model ContainerRestartLibpodInternalServerErrorBody
*/
type ContainerRestartLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container restart libpod internal server error body
func (o *ContainerRestartLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container restart libpod internal server error body based on context it is used
func (o *ContainerRestartLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerRestartLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerRestartLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerRestartLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerRestartLibpodNotFoundBody container restart libpod not found body
swagger:model ContainerRestartLibpodNotFoundBody
*/
type ContainerRestartLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container restart libpod not found body
func (o *ContainerRestartLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container restart libpod not found body based on context it is used
func (o *ContainerRestartLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerRestartLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerRestartLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerRestartLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
