// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerRestoreLibpodParams creates a new ContainerRestoreLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerRestoreLibpodParams() *ContainerRestoreLibpodParams {
	return &ContainerRestoreLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerRestoreLibpodParamsWithTimeout creates a new ContainerRestoreLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerRestoreLibpodParamsWithTimeout(timeout time.Duration) *ContainerRestoreLibpodParams {
	return &ContainerRestoreLibpodParams{
		timeout: timeout,
	}
}

// NewContainerRestoreLibpodParamsWithContext creates a new ContainerRestoreLibpodParams object
// with the ability to set a context for a request.
func NewContainerRestoreLibpodParamsWithContext(ctx context.Context) *ContainerRestoreLibpodParams {
	return &ContainerRestoreLibpodParams{
		Context: ctx,
	}
}

// NewContainerRestoreLibpodParamsWithHTTPClient creates a new ContainerRestoreLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerRestoreLibpodParamsWithHTTPClient(client *http.Client) *ContainerRestoreLibpodParams {
	return &ContainerRestoreLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerRestoreLibpodParams contains all the parameters to send to the API endpoint

	for the container restore libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerRestoreLibpodParams struct {

	/* IgnoreRootFS.

	   do not include root file-system changes when exporting
	*/
	IgnoreRootFS *bool

	/* IgnoreStaticIP.

	   ignore IP address if set statically
	*/
	IgnoreStaticIP *bool

	/* IgnoreStaticMAC.

	   ignore MAC address if set statically
	*/
	IgnoreStaticMAC *bool

	/* Import.

	   import the restore from a checkpoint tar.gz
	*/
	Import *bool

	/* Keep.

	   keep all temporary checkpoint files
	*/
	Keep *bool

	/* LeaveRunning.

	   leave the container running after writing checkpoint to disk
	*/
	LeaveRunning *bool

	/* Name.

	   the name of the container when restored from a tar. can only be used with import
	*/
	QueryName *string

	/* Name.

	   the name or id of the container
	*/
	PathName string

	/* PrintStats.

	   add restore statistics to the returned RestoreReport
	*/
	PrintStats *bool

	/* TCPEstablished.

	   checkpoint a container with established TCP connections
	*/
	TCPEstablished *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container restore libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerRestoreLibpodParams) WithDefaults() *ContainerRestoreLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container restore libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerRestoreLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithTimeout(timeout time.Duration) *ContainerRestoreLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithContext(ctx context.Context) *ContainerRestoreLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithHTTPClient(client *http.Client) *ContainerRestoreLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIgnoreRootFS adds the ignoreRootFS to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithIgnoreRootFS(ignoreRootFS *bool) *ContainerRestoreLibpodParams {
	o.SetIgnoreRootFS(ignoreRootFS)
	return o
}

// SetIgnoreRootFS adds the ignoreRootFS to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetIgnoreRootFS(ignoreRootFS *bool) {
	o.IgnoreRootFS = ignoreRootFS
}

// WithIgnoreStaticIP adds the ignoreStaticIP to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithIgnoreStaticIP(ignoreStaticIP *bool) *ContainerRestoreLibpodParams {
	o.SetIgnoreStaticIP(ignoreStaticIP)
	return o
}

// SetIgnoreStaticIP adds the ignoreStaticIp to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetIgnoreStaticIP(ignoreStaticIP *bool) {
	o.IgnoreStaticIP = ignoreStaticIP
}

// WithIgnoreStaticMAC adds the ignoreStaticMAC to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithIgnoreStaticMAC(ignoreStaticMAC *bool) *ContainerRestoreLibpodParams {
	o.SetIgnoreStaticMAC(ignoreStaticMAC)
	return o
}

// SetIgnoreStaticMAC adds the ignoreStaticMAC to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetIgnoreStaticMAC(ignoreStaticMAC *bool) {
	o.IgnoreStaticMAC = ignoreStaticMAC
}

// WithImport adds the importVar to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithImport(importVar *bool) *ContainerRestoreLibpodParams {
	o.SetImport(importVar)
	return o
}

// SetImport adds the import to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetImport(importVar *bool) {
	o.Import = importVar
}

// WithKeep adds the keep to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithKeep(keep *bool) *ContainerRestoreLibpodParams {
	o.SetKeep(keep)
	return o
}

// SetKeep adds the keep to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetKeep(keep *bool) {
	o.Keep = keep
}

// WithLeaveRunning adds the leaveRunning to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithLeaveRunning(leaveRunning *bool) *ContainerRestoreLibpodParams {
	o.SetLeaveRunning(leaveRunning)
	return o
}

// SetLeaveRunning adds the leaveRunning to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetLeaveRunning(leaveRunning *bool) {
	o.LeaveRunning = leaveRunning
}

// WithQueryName adds the name to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithQueryName(name *string) *ContainerRestoreLibpodParams {
	o.SetQueryName(name)
	return o
}

// SetQueryName adds the name to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetQueryName(name *string) {
	o.QueryName = name
}

// WithPathName adds the name to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithPathName(name string) *ContainerRestoreLibpodParams {
	o.SetPathName(name)
	return o
}

// SetPathName adds the name to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetPathName(name string) {
	o.PathName = name
}

// WithPrintStats adds the printStats to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithPrintStats(printStats *bool) *ContainerRestoreLibpodParams {
	o.SetPrintStats(printStats)
	return o
}

// SetPrintStats adds the printStats to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetPrintStats(printStats *bool) {
	o.PrintStats = printStats
}

// WithTCPEstablished adds the tCPEstablished to the container restore libpod params
func (o *ContainerRestoreLibpodParams) WithTCPEstablished(tCPEstablished *bool) *ContainerRestoreLibpodParams {
	o.SetTCPEstablished(tCPEstablished)
	return o
}

// SetTCPEstablished adds the tcpEstablished to the container restore libpod params
func (o *ContainerRestoreLibpodParams) SetTCPEstablished(tCPEstablished *bool) {
	o.TCPEstablished = tCPEstablished
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerRestoreLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.IgnoreRootFS != nil {

		// query param ignoreRootFS
		var qrIgnoreRootFS bool

		if o.IgnoreRootFS != nil {
			qrIgnoreRootFS = *o.IgnoreRootFS
		}
		qIgnoreRootFS := swag.FormatBool(qrIgnoreRootFS)
		if qIgnoreRootFS != "" {

			if err := r.SetQueryParam("ignoreRootFS", qIgnoreRootFS); err != nil {
				return err
			}
		}
	}

	if o.IgnoreStaticIP != nil {

		// query param ignoreStaticIP
		var qrIgnoreStaticIP bool

		if o.IgnoreStaticIP != nil {
			qrIgnoreStaticIP = *o.IgnoreStaticIP
		}
		qIgnoreStaticIP := swag.FormatBool(qrIgnoreStaticIP)
		if qIgnoreStaticIP != "" {

			if err := r.SetQueryParam("ignoreStaticIP", qIgnoreStaticIP); err != nil {
				return err
			}
		}
	}

	if o.IgnoreStaticMAC != nil {

		// query param ignoreStaticMAC
		var qrIgnoreStaticMAC bool

		if o.IgnoreStaticMAC != nil {
			qrIgnoreStaticMAC = *o.IgnoreStaticMAC
		}
		qIgnoreStaticMAC := swag.FormatBool(qrIgnoreStaticMAC)
		if qIgnoreStaticMAC != "" {

			if err := r.SetQueryParam("ignoreStaticMAC", qIgnoreStaticMAC); err != nil {
				return err
			}
		}
	}

	if o.Import != nil {

		// query param import
		var qrImport bool

		if o.Import != nil {
			qrImport = *o.Import
		}
		qImport := swag.FormatBool(qrImport)
		if qImport != "" {

			if err := r.SetQueryParam("import", qImport); err != nil {
				return err
			}
		}
	}

	if o.Keep != nil {

		// query param keep
		var qrKeep bool

		if o.Keep != nil {
			qrKeep = *o.Keep
		}
		qKeep := swag.FormatBool(qrKeep)
		if qKeep != "" {

			if err := r.SetQueryParam("keep", qKeep); err != nil {
				return err
			}
		}
	}

	if o.LeaveRunning != nil {

		// query param leaveRunning
		var qrLeaveRunning bool

		if o.LeaveRunning != nil {
			qrLeaveRunning = *o.LeaveRunning
		}
		qLeaveRunning := swag.FormatBool(qrLeaveRunning)
		if qLeaveRunning != "" {

			if err := r.SetQueryParam("leaveRunning", qLeaveRunning); err != nil {
				return err
			}
		}
	}

	if o.QueryName != nil {

		// query param name
		var qrName string

		if o.QueryName != nil {
			qrName = *o.QueryName
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.PathName); err != nil {
		return err
	}

	if o.PrintStats != nil {

		// query param printStats
		var qrPrintStats bool

		if o.PrintStats != nil {
			qrPrintStats = *o.PrintStats
		}
		qPrintStats := swag.FormatBool(qrPrintStats)
		if qPrintStats != "" {

			if err := r.SetQueryParam("printStats", qPrintStats); err != nil {
				return err
			}
		}
	}

	if o.TCPEstablished != nil {

		// query param tcpEstablished
		var qrTCPEstablished bool

		if o.TCPEstablished != nil {
			qrTCPEstablished = *o.TCPEstablished
		}
		qTCPEstablished := swag.FormatBool(qrTCPEstablished)
		if qTCPEstablished != "" {

			if err := r.SetQueryParam("tcpEstablished", qTCPEstablished); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
