// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerStatsLibpodParams creates a new ContainerStatsLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerStatsLibpodParams() *ContainerStatsLibpodParams {
	return &ContainerStatsLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerStatsLibpodParamsWithTimeout creates a new ContainerStatsLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerStatsLibpodParamsWithTimeout(timeout time.Duration) *ContainerStatsLibpodParams {
	return &ContainerStatsLibpodParams{
		timeout: timeout,
	}
}

// NewContainerStatsLibpodParamsWithContext creates a new ContainerStatsLibpodParams object
// with the ability to set a context for a request.
func NewContainerStatsLibpodParamsWithContext(ctx context.Context) *ContainerStatsLibpodParams {
	return &ContainerStatsLibpodParams{
		Context: ctx,
	}
}

// NewContainerStatsLibpodParamsWithHTTPClient creates a new ContainerStatsLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerStatsLibpodParamsWithHTTPClient(client *http.Client) *ContainerStatsLibpodParams {
	return &ContainerStatsLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerStatsLibpodParams contains all the parameters to send to the API endpoint

	for the container stats libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerStatsLibpodParams struct {

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* Stream.

	   Stream the output

	   Default: true
	*/
	Stream *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container stats libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerStatsLibpodParams) WithDefaults() *ContainerStatsLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container stats libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerStatsLibpodParams) SetDefaults() {
	var (
		streamDefault = bool(true)
	)

	val := ContainerStatsLibpodParams{
		Stream: &streamDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the container stats libpod params
func (o *ContainerStatsLibpodParams) WithTimeout(timeout time.Duration) *ContainerStatsLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container stats libpod params
func (o *ContainerStatsLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container stats libpod params
func (o *ContainerStatsLibpodParams) WithContext(ctx context.Context) *ContainerStatsLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container stats libpod params
func (o *ContainerStatsLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container stats libpod params
func (o *ContainerStatsLibpodParams) WithHTTPClient(client *http.Client) *ContainerStatsLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container stats libpod params
func (o *ContainerStatsLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the container stats libpod params
func (o *ContainerStatsLibpodParams) WithName(name string) *ContainerStatsLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container stats libpod params
func (o *ContainerStatsLibpodParams) SetName(name string) {
	o.Name = name
}

// WithStream adds the stream to the container stats libpod params
func (o *ContainerStatsLibpodParams) WithStream(stream *bool) *ContainerStatsLibpodParams {
	o.SetStream(stream)
	return o
}

// SetStream adds the stream to the container stats libpod params
func (o *ContainerStatsLibpodParams) SetStream(stream *bool) {
	o.Stream = stream
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerStatsLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Stream != nil {

		// query param stream
		var qrStream bool

		if o.Stream != nil {
			qrStream = *o.Stream
		}
		qStream := swag.FormatBool(qrStream)
		if qStream != "" {

			if err := r.SetQueryParam("stream", qStream); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
