// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ContainerTopLibpodReader is a Reader for the ContainerTopLibpod structure.
type ContainerTopLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerTopLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewContainerTopLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerTopLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerTopLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerTopLibpodOK creates a ContainerTopLibpodOK with default headers values
func NewContainerTopLibpodOK() *ContainerTopLibpodOK {
	return &ContainerTopLibpodOK{}
}

/*
ContainerTopLibpodOK describes a response with status code 200, with default header values.

List processes in container
*/
type ContainerTopLibpodOK struct {
	Payload *ContainerTopLibpodOKBody
}

// IsSuccess returns true when this container top libpod o k response has a 2xx status code
func (o *ContainerTopLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container top libpod o k response has a 3xx status code
func (o *ContainerTopLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container top libpod o k response has a 4xx status code
func (o *ContainerTopLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this container top libpod o k response has a 5xx status code
func (o *ContainerTopLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this container top libpod o k response a status code equal to that given
func (o *ContainerTopLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ContainerTopLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/top][%d] containerTopLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerTopLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/top][%d] containerTopLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerTopLibpodOK) GetPayload() *ContainerTopLibpodOKBody {
	return o.Payload
}

func (o *ContainerTopLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerTopLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerTopLibpodNotFound creates a ContainerTopLibpodNotFound with default headers values
func NewContainerTopLibpodNotFound() *ContainerTopLibpodNotFound {
	return &ContainerTopLibpodNotFound{}
}

/*
ContainerTopLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerTopLibpodNotFound struct {
	Payload *ContainerTopLibpodNotFoundBody
}

// IsSuccess returns true when this container top libpod not found response has a 2xx status code
func (o *ContainerTopLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container top libpod not found response has a 3xx status code
func (o *ContainerTopLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container top libpod not found response has a 4xx status code
func (o *ContainerTopLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container top libpod not found response has a 5xx status code
func (o *ContainerTopLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container top libpod not found response a status code equal to that given
func (o *ContainerTopLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerTopLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/top][%d] containerTopLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerTopLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/top][%d] containerTopLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerTopLibpodNotFound) GetPayload() *ContainerTopLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerTopLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerTopLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerTopLibpodInternalServerError creates a ContainerTopLibpodInternalServerError with default headers values
func NewContainerTopLibpodInternalServerError() *ContainerTopLibpodInternalServerError {
	return &ContainerTopLibpodInternalServerError{}
}

/*
ContainerTopLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerTopLibpodInternalServerError struct {
	Payload *ContainerTopLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container top libpod internal server error response has a 2xx status code
func (o *ContainerTopLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container top libpod internal server error response has a 3xx status code
func (o *ContainerTopLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container top libpod internal server error response has a 4xx status code
func (o *ContainerTopLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container top libpod internal server error response has a 5xx status code
func (o *ContainerTopLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container top libpod internal server error response a status code equal to that given
func (o *ContainerTopLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerTopLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/top][%d] containerTopLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerTopLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/top][%d] containerTopLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerTopLibpodInternalServerError) GetPayload() *ContainerTopLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerTopLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerTopLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerTopLibpodInternalServerErrorBody container top libpod internal server error body
swagger:model ContainerTopLibpodInternalServerErrorBody
*/
type ContainerTopLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container top libpod internal server error body
func (o *ContainerTopLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container top libpod internal server error body based on context it is used
func (o *ContainerTopLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerTopLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerTopLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerTopLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerTopLibpodNotFoundBody container top libpod not found body
swagger:model ContainerTopLibpodNotFoundBody
*/
type ContainerTopLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container top libpod not found body
func (o *ContainerTopLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container top libpod not found body based on context it is used
func (o *ContainerTopLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerTopLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerTopLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerTopLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerTopLibpodOKBody container top libpod o k body
swagger:model ContainerTopLibpodOKBody
*/
type ContainerTopLibpodOKBody struct {

	// Each process running in the container, where each is process
	// is an array of values corresponding to the titles.
	// Required: true
	Processes [][]string `json:"Processes"`

	// The ps column titles
	// Required: true
	Titles []string `json:"Titles"`
}

// Validate validates this container top libpod o k body
func (o *ContainerTopLibpodOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateProcesses(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTitles(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ContainerTopLibpodOKBody) validateProcesses(formats strfmt.Registry) error {

	if err := validate.Required("containerTopLibpodOK"+"."+"Processes", "body", o.Processes); err != nil {
		return err
	}

	return nil
}

func (o *ContainerTopLibpodOKBody) validateTitles(formats strfmt.Registry) error {

	if err := validate.Required("containerTopLibpodOK"+"."+"Titles", "body", o.Titles); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this container top libpod o k body based on context it is used
func (o *ContainerTopLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerTopLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerTopLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res ContainerTopLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
